/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package exenne.components.tree.expansion;

import exenne.components.tree.expansion.validators.ForbidenClassesValidator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.List;
import java.util.Vector;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

/**
 *
 * @author iulian
 */
public class TreeNodesUtils {
    
      /*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
      *    Search utils
      *~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/

    /**
     * Cauta un obiect in arbore. Arborele se parcurge in maniera
     * @param object
     * @return
     */
    public static DefaultMutableTreeNode findObjectInTree(DefaultMutableTreeNode node,
            Object object) {
        Enumeration enumeration = node.breadthFirstEnumeration();

        while (enumeration.hasMoreElements()) {
            DefaultMutableTreeNode nodeItem = (DefaultMutableTreeNode)
                    enumeration.nextElement();
            Object userObject = nodeItem.getUserObject();

            if (object != null && object.equals(userObject))
                return nodeItem;
        }

        //Daca nu s-a gasit nimic intorc null
        return null;
    }

    /**
     * Cauta un obiect in arbore. Arborele se parcurge in maniera
     * @param object
     * @return
     */
    public static Vector<DefaultMutableTreeNode> findObjectsInTree(DefaultMutableTreeNode node,
            Vector<Object> objects) {
        Vector<DefaultMutableTreeNode> foundNodes = new Vector<DefaultMutableTreeNode>();

        Enumeration enumeration = node.depthFirstEnumeration();
        while (enumeration.hasMoreElements()) {
            DefaultMutableTreeNode nodeItem = (DefaultMutableTreeNode)
                    enumeration.nextElement();
            Object userObject = nodeItem.getUserObject();

            if (objects.contains(userObject))
                foundNodes.add(nodeItem);
        }

        //Daca nu s-a gasit nimic intorc null
        return foundNodes;
    }

     /**~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
      *    General purpose expansion
      *~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/
    
    /**
     * Face expand complet la un arbore
     * expand = true - expandAll else collapseAll
     */
    public static void expandAll(ExpandableComponent expandableComponent) {
        TreeNode root = expandableComponent.getRootNode();
        expandAll(expandableComponent, new TreePath(root));
    }

    /**
     * Face expand complet la un arbore
     * expand = true - expandAll else collapseAll
     */
    public static void expandAll(ExpandableComponent expandableComponent,
            DefaultMutableTreeNode root) {
        // Traverse tree from root
        expandAll(expandableComponent, new TreePath(root));
    }

    /**
     * Face expand complet la un treetable pornind de la root
     * expand = true - expandAll else collapseAll
     */
    private static void expandAll(ExpandableComponent expandableComponent, 
            TreePath parent) {
        // Traverse children
        TreeNode node = (TreeNode)parent.getLastPathComponent();
        if (node.getChildCount() >= 0) {
            for (Enumeration e=node.children(); e.hasMoreElements(); ) {
                TreeNode n = (TreeNode)e.nextElement();
                if (!n.isLeaf())
                {
                    TreePath path = parent.pathByAddingChild(n);
                    expandAll(expandableComponent, path);
                }
            }
        }
        // Expansion must be done bottom-up
        expandableComponent.expandPath(parent);
    }

     /**~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
      *    General purpose colapse
      *~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/
    
    /**
     * Face expand complet la un arbore
     * expand = true - expandAll else collapseAll
     */
    public static void collapseAll(ExpandableComponent expandableComponent) {
        TreeNode root = expandableComponent.getRootNode();
        collapseAll(expandableComponent, new TreePath(root));
    }

    /**
     * Face expand complet la un arbore
     * expand = true - expandAll else collapseAll
     */
    public static void collapseAll(ExpandableComponent expandableComponent,
            DefaultMutableTreeNode root) {
        // Traverse tree from root
        collapseAll(expandableComponent, new TreePath(root));
    }

    /**
     * Face expand complet la un treetable pornind de la root
     * expand = true - expandAll else collapseAll
     */
    private static void collapseAll(ExpandableComponent expandableComponent, 
            TreePath parent) {
        // Traverse children
        TreeNode node = (TreeNode)parent.getLastPathComponent();
        if (node.getChildCount() >= 0) {
            for (Enumeration e=node.children(); e.hasMoreElements(); ) {
                TreeNode n = (TreeNode)e.nextElement();
                if (!n.isLeaf())
                {
                    TreePath path = parent.pathByAddingChild(n);
                    collapseAll(expandableComponent, path);
                }
            }
        }
        // Collapse must be done bottom-up
        boolean isRoot = ((DefaultMutableTreeNode)parent.getLastPathComponent()).isRoot();
        if (!isRoot) expandableComponent.collapsePath(parent);
    }
    
     /**~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
      *    Expansion with validation
      *~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/
    
    /**
     * Face expand complet la un treetable excluzand anumite clase
     * expand = true - expandAll else collapseAll
     */
    public static void expandAllButClasses(ExpandableComponent expandableComponent,
            Class... forbidenClasses) {
        TreeNode root = expandableComponent.getRootNode();
        // Traverse tree from root
        expandAllButClasses(expandableComponent, new TreePath(root));
    }
    
    /**
     * Face expand complet la un treetable ce contine ElementeDevizGeneral
     * expand = true - expandAll else collapseAll
     */
    public static void expandAllButClasses(ExpandableComponent expandableComponent,
            TreePath parent, Class... forbidenClasses) {
        // Traverse children
        List forbidenClassesList = Arrays.asList(forbidenClasses);
        ForbidenClassesValidator validator = new ForbidenClassesValidator(forbidenClassesList);
        expandAllWithValidation(expandableComponent, parent, validator);
    }

    /**
     * Face expand complet la un treetable ce contine ElementeDevizGeneral
     * expand = true - expandAll else collapseAll
     */
    public static void expandAllWithValidation(ExpandableComponent expandableComponent, 
            NodeExpansionValidator validator) {
        TreeNode root = expandableComponent.getRootNode();
        // Traverse tree from root
        expandAllWithValidation(expandableComponent, new TreePath(root), validator);
    }
    
    /**
     * Face expand complet la un treetable ce contine ElementeDevizGeneral
     * expand = true - expandAll else collapseAll
     */
    public static void expandAllWithValidation(ExpandableComponent expandableComponent, 
            TreePath parent, NodeExpansionValidator validator) {
        // Traverse children
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)
                parent.getLastPathComponent();
        if (node.getChildCount() >= 0) {
            for (Enumeration e=node.children(); e.hasMoreElements(); ) {
                DefaultMutableTreeNode n = (DefaultMutableTreeNode) e.nextElement();
                Object object =  n.getUserObject();
                if ((!n.isLeaf()) && (validator.validate(object)))
                {
                    TreePath path = parent.pathByAddingChild(n);
                    expandAllWithValidation(expandableComponent, path, validator);
                }
            }
        }
        // Expansion  must be done bottom-up
        expandableComponent.expandPath(parent);
    }
    
      /*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
      *    Expansion with level select
      *~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/
    
    /**
     * Extinde pana la un anumit nivel
     * @param expandableComponent
     * @param expand
     * @param level 
     */
    public static void expandToLevel(ExpandableComponent expandableComponent,
            int level) {
        TreeNode root = expandableComponent.getRootNode();
        expandToLevel(expandableComponent, new TreePath(root), level);
    }
    
    /**
     * Face expand pana la un anumit nivel
     * @param expandableComponent
     * @param expand
     * @param level Nivelul pana la care se extinde. Primul nivel este 1
     */
    public static void expandToLevel(ExpandableComponent expandableComponent, 
            TreePath parent,  int level) {
        expandToLevel(expandableComponent, parent, level, 1);
    }
    
    /**
     * Face expand pana la un anumit nivel
     * @param expandableComponent
     * @param expand
     * @param level Nivelul pana la care se extinde. Primul nivel este 1
     */
    private static void expandToLevel(ExpandableComponent expandableComponent, 
            TreePath parent,  int level, int currentLevel) {
        if (currentLevel < level) {
            // Traverse children
            TreeNode node = (TreeNode)parent.getLastPathComponent();
            if (node.getChildCount() >= 0) {
                for (Enumeration e=node.children(); e.hasMoreElements(); ) {
                    TreeNode n = (TreeNode)e.nextElement();
                    if (!n.isLeaf())
                    {
                        TreePath path = parent.pathByAddingChild(n);
                        expandToLevel(expandableComponent, path, level, currentLevel+1);
                    }
                }
            }
        }
        
        // Expansion must be done bottom-up
        expandableComponent.expandPath(parent);
    }
    
     /**~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
      *    Expansion with element count
      *~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/
    
    /**
     * Alege nivelul de extindere astfel incat sa se afiseze in limita de noduri impusa
     * @param expandableComponent
     * @param parent 
     */
    public static void expandToOptimalCoverage(ExpandableComponent expandableComponent, int nodeLimit) {
        TreeNode root = expandableComponent.getRootNode();
        expandToOptimalCoverage(expandableComponent, new TreePath(root), nodeLimit);
    }
    
    /**
     * Alege nivelul de extindere astfel incat sa se afiseze in limita de noduri impusa
     * @param expandableComponent
     * @param parent 
     */
    public static void expandToOptimalCoverage(ExpandableComponent expandableComponent, 
            TreePath parent, int nodeLimit) {
        TreeNode parentNode  = (TreeNode) parent.getPathComponent(0);
        ArrayList <Integer> nodeCountByLevel = getNodeCountByLevel(parentNode);
        int prefferedLevel = 0;
        int currentNodes = 0;
        
        //Caut nivelul optim pentru a ma incardra in limita
        for (int i = 0; i < nodeCountByLevel.size(); i++) {
            Integer value = nodeCountByLevel.get(i);
            
            //Testez validitatea nivelului
            currentNodes += value;
            if (currentNodes < nodeLimit)
                prefferedLevel = i;
        }

        //Extind folosind nivelul optinut
        expandToLevel(expandableComponent, parent, prefferedLevel);
    }    
    
    /**
     * Numar elementele de pe fiecare nivel dintr-un arbore
     * @param parentNode 
     */
    private static ArrayList <Integer> getNodeCountByLevel(TreeNode parentNode) {
        ArrayList <Integer> levelCount = new ArrayList<Integer>();
        ArrayList <TreeNode> currentNodes = new ArrayList<TreeNode> ();
        ArrayList <TreeNode> nextNodes = new ArrayList<TreeNode> ();
        int currentLevel;
        int childNumber;
        
        //Cazul in care primesc nod parinte null
        if (parentNode == null)
            return levelCount;
        
        //Initializez structurile de numarare
        currentLevel = 0;
        nextNodes.add(parentNode);
        childNumber = nextNodes.size();
        levelCount.add(currentLevel, childNumber); //Am 1 element pe nivelul 0 (root)
        currentLevel++;
        
        //Parcurg nodurile Breadth First
        while (childNumber != 0) {
            //Nodurile urmatoare devin noduri curente
            ArrayList <TreeNode> auxList = currentNodes;
            currentNodes = nextNodes;
            nextNodes = auxList;
            nextNodes.clear();
            
            //Caut copii nodurilor curente
            for (TreeNode nodeItem : currentNodes) {
                if (nodeItem.getChildCount() >= 0) {
                    for (Enumeration e=nodeItem.children(); e.hasMoreElements(); ) {
                        TreeNode nodeChildren = (TreeNode)e.nextElement();
                        nextNodes.add(nodeChildren);
                    }
                }
            }

            //Numar copii obtinuti in acest nivel
            childNumber = nextNodes.size();
            if (childNumber > 0) {
                levelCount.add(currentLevel,childNumber);
                currentLevel++;
            }
        }
        
        //Afisez rezultatul
        return levelCount;
    }
    
    /**~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
     *     Metoda de test
     *~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/
    
    /**
     * Metoda de test
     * @param args 
     */
    public static void main(String[] args) {
        DefaultMutableTreeNode rootNode = new DefaultMutableTreeNode("rootNode");
        DefaultMutableTreeNode child1 = new DefaultMutableTreeNode("child1");
            DefaultMutableTreeNode child1_1 = new DefaultMutableTreeNode("child1_1");
            DefaultMutableTreeNode child1_2 = new DefaultMutableTreeNode("child1_2");
            DefaultMutableTreeNode child1_3 = new DefaultMutableTreeNode("child1_3");
        DefaultMutableTreeNode child2 = new DefaultMutableTreeNode("child2");
            DefaultMutableTreeNode child2_1 = new DefaultMutableTreeNode("child2_1");
        DefaultMutableTreeNode child3 = new DefaultMutableTreeNode("child3");
            DefaultMutableTreeNode child3_1 = new DefaultMutableTreeNode("child3_1");
            DefaultMutableTreeNode child3_2 = new DefaultMutableTreeNode("child3_2");
            
        //Fac arborele
        rootNode.add(child1);
            child1.add(child1_1);
            child1.add(child1_2);
            child1.add(child1_3);
        rootNode.add(child2);
            child2.add(child2_1);
        rootNode.add(child3);
            child3.add(child3_1);
            child3.add(child3_2);
            
        //Obtin numaratoarea nodurilor
        ArrayList <Integer> nodeCountByLevel = getNodeCountByLevel(rootNode);
        System.out.println(nodeCountByLevel);
    }
}
