/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright 1997-2009 Sun Microsystems, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common
 * Development and Distribution License("CDDL") (collectively, the
 * "License"). You may not use this file except in compliance with the
 * License. You can obtain a copy of the License at
 * http://www.netbeans.org/cddl-gplv2.html
 * or nbbuild/licenses/CDDL-GPL-2-CP. See the License for the
 * specific language governing permissions and limitations under the
 * License.  When distributing the software, include this License Header
 * Notice in each file and include the License file at
 * nbbuild/licenses/CDDL-GPL-2-CP.  Sun designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Sun in the GPL Version 2 section of the License file that
 * accompanied this code. If applicable, add the following below the
 * License Header, with the fields enclosed by brackets [] replaced by
 * your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Contributor(s):
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 *
 * If you wish your version of this file to be governed by only the CDDL
 * or only the GPL Version 2, indicate your decision by adding
 * "[Contributor] elects to include this software in this distribution
 * under the [CDDL or GPL Version 2] license." If you do not indicate a
 * single choice of license, a recipient has the option to distribute
 * your version of this file under either the CDDL, the GPL Version 2 or
 * to extend the choice of license to its licensees as provided above.
 * However, if you add GPL Version 2 code and therefore, elected the GPL
 * Version 2 license, then the option applies only if the new code is
 * made subject to such option by the copyright holder.
 */
package org.netbeans.validation.api.builtin;

import java.text.DateFormat;
import java.text.ParseException;
import java.util.Date;
import org.netbeans.validation.api.Problems;
import org.netbeans.validation.api.Validator;
import org.openide.util.bundle.NbBundle;

/**
 *
 * @author Tim Boudreau
 */
public final class DateDayRange implements Validator<String> {
    private DateFormat dateFormatter;
    private Date max;
    private Date min;
    private boolean isExclusive;
    
    //Stringuri pentru afisarea capetelor
    private String textMin = "";
    private String textMax = "";
    
    /**
     * The date should fall into the specified range
     * @param dateFormatter
     * @param min
     * @param max 
     */
    public DateDayRange (DateFormat dateFormatter, Date min, Date max) {
        this(dateFormatter, min, max, false);
    }
    
    /**
     * The date should fall into the range
     * @param min
     * @param max 
     */
    public DateDayRange (DateFormat dateFormatter, Date min, Date max, boolean isExclusive) {
        this.dateFormatter = dateFormatter;
        this.min = min;
        this.max = max;
        this.isExclusive = isExclusive;
        
        //Initializez stringurile pentru capete
        if (min != null)
            textMin = dateFormatter.format(min);
        if (max != null)
            textMax = dateFormatter.format(max);
    }

    /**
     * Validate the resulting string
     * @param problems
     * @param compName
     * @param model
     * @return 
     */
    public boolean validate(Problems problems, String compName, String model) {
        try {
            Date valDate = dateFormatter.parse(model);
            
            //Minimum check
            boolean minOk = true;
            if (min != null) {
                int differenceMin = compareDayDate(valDate, min);
                if (isExclusive) {
                    minOk = differenceMin > 0;
                } else {
                    minOk = differenceMin >= 0;
                }
                if (!minOk) {
                    problems.add (NbBundle.getMessage(DateDayRange.class,
                            "DATE_TOO_LOW", new Object[] { //NOI18N
                            compName, textMin, model})); 
                }
            }
            
            //Maximum check
            boolean maxOk = true;
            if (max != null) {
                int differenceMax = compareDayDate(max, valDate);
                if (isExclusive) {
                    maxOk = differenceMax > 0;
                } else {
                    maxOk = differenceMax >= 0;
                }
                if (!maxOk) {
                    problems.add (NbBundle.getMessage(DateDayRange.class,
                            "DATE_TOO_HIGH", new Object[] { //NOI18N
                            compName, textMax, model})); 
                }
            }
            
            //Check both ways
            return minOk && maxOk;
        } catch (ParseException e) {
            //should be handled by another validator
        }
        return true;
    }

    
    /**~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
     *    Date utils
     *~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/

    /**
     * Compare two dates
     * @param date1
     * @param date2
     * @return 0 - equal, negative if date1 < date2, positive if date1 > date2
     */
    private int compareDayDate(Date date1, Date date2) {
        //Compare year
        int yearDifference = date1.getYear() - date2.getYear();
        if (yearDifference != 0) {
            return yearDifference;
        }
        
        //Compare month
        int monthsDifference = date1.getMonth() - date2.getMonth();
        if (monthsDifference != 0) {
            return monthsDifference;
        }
        
        //Compare days
        int daysDifference = date1.getDate() - date2.getDate();
        if (daysDifference != 0) {
            return daysDifference;
        }
        
        //Dates are equal
        return 0;
    }
}
