/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package exenne.components.coloredtable.cellrenderers;

import exenne.components.coloredtable.AbstractColoredTableModel;
import exenne.components.coloredtable.JColoredTable;
import exenne.components.utils.GraphicRenderingUtils;
import exenne.components.utils.NumberUtils;
import java.awt.Color;
import java.awt.Component;
import java.math.BigDecimal;
import javax.swing.JTable;
import javax.swing.SwingConstants;
import javax.swing.table.DefaultTableCellRenderer;

/**
 *
 * @author iulian
 */
public abstract class AbstractColoredCellRenderer extends DefaultTableCellRenderer {
    //Surse de date
    private JColoredTable coloredTable = null;
    private AbstractColoredTableModel coloredTableModel = null;

    //Variabile booleane puse la dispozitie de catre clasa
    private boolean isSelected = false;
    private boolean hasSomeFocus = false;
    private boolean isCellEditable = false;
    private boolean hasToolTipText = false;

    //Variabile de stare
    private Color prefferedBackground = null;
    private Color prefferedForeground = null;
    private int colorOffset;

    /**~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
     *      Construierea renderului
     *~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/

    /**
     * Constructorul default
     */
    public AbstractColoredCellRenderer() {
        super();

        //Initializez default
        colorOffset = 15;
    }

    /**~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
     *      Acces la sursele de date
     *~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/    

    /**
     * Obtin colored table-ul caruia se adreseaza renderul
     * @return
     */
    public JColoredTable getColoredTable() {
        return coloredTable;
    }

    /**
     * Obtin modelul pe care se bazeaza tabelul
     * @return
     */
    public AbstractColoredTableModel getColoredTableModel() {
        return coloredTableModel;
    }

    /**~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
     *     Obtinerea variabilelor puse la
     *      dispozitie pentru desenare
     *~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/
    /**
     * Obtin daca randul este selectat
     * @return
     */
    public boolean isSelected() {
        return isSelected;
    }    

    /**
     * Obtin daca celula are focus in acest moment
     * @return
     */
    public boolean hasSomeFocus() {
        return hasSomeFocus;
    }

    /**
     * Obtin daca celula este editabila
     * @return
     */
    public boolean isCellEditable() {
        return isCellEditable;
    }    

    /**
     * Obtin daca cell rederul are tooltip text
     * @return
     */
    public boolean hasToolTipText() {
        return hasToolTipText;
    }

    /**
     * Obtin backgroundul preferat de model
     * @return
     */
    public Color getPrefferedBackground() {
        return prefferedBackground;
    }

    /**
     * Obtin foregroundul preferat de model
     * @return
     */
    public Color getPrefferedForeground() {
        return prefferedForeground;
    }

    /**
     * Obtin offsetul de culoare intre randuri
     * @return
     */
    public int getColorOffset() {
        return colorOffset;
    }

    /**~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
     *     Setarea variabilelor puse la
     *      dispozitie pentru desenare
     *~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/

    /**
     * Setez faptul ca acest rand este selectat
     * @param isSelected
     */
    protected void setIsSelected(boolean isSelected) {
        this.isSelected = isSelected;
    }    

    /**
     * Setez faptul ca aceasta componenta are focus
     * @param hasSomeFocus
     */
    protected void setHasSomeFocus(boolean hasSomeFocus) {
        this.hasSomeFocus = hasSomeFocus;
    }

    /**
     * Setez faptul ca celula este editabila
     * @param isCellEditable
     */
    protected void setIsCellEditable(boolean isCellEditable) {
        this.isCellEditable = isCellEditable;
    }    

    /**
     * Setez faptul ca are tooltiptext
     * @param hasToolTipText
     */
    protected void setHasToolTipText(boolean hasToolTipText) {
        this.hasToolTipText = hasToolTipText;
    }

    /**
     * Setez culoare preferata de model
     * @param prefferedBackground
     */
    protected void setPrefferedBackground(Color prefferedBackground) {
        this.prefferedBackground = prefferedBackground;
    }

    /**
     * Setez culoare preferata de model
     * @param prefferedForeground
     */
    protected void setPrefferedForeground(Color prefferedForeground) {
        this.prefferedForeground = prefferedForeground;
    }

    /**
     * Setez diferenta de culoare intre randuri
     * @param colorOffset
     */
    protected void setColorOffset(int colorOffset) {
        this.colorOffset = colorOffset;
    }

    /**~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
     *      Construieste componenta ce
     *      va fi trimisa spre desenare
     *~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/

    /**
     * Obtin componenta ce va fi rendata in celula
     * @param table
     * @param value
     * @param isSelected
     * @param hasFocus
     * @param row
     * @param column
     * @return
     */
    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, 
            boolean isSelected, boolean hasFocus, int row, int column) {

        //Apel in parinte pentru a seta el variabilele default
        super.getTableCellRendererComponent(table, value,
                        isSelected, hasFocus, row, column);

        //Surse de date
        coloredTable = (JColoredTable) table;
        coloredTableModel = coloredTable.getModel();

        //Translatez randul in randul de model
        int modelrow = coloredTable.convertRowIndexToModel(row);
        int modelcolumn = coloredTable.convertColumnIndexToModel(column);

        //Variabile boolene de stare
        this.isSelected = isSelected;
        this.hasSomeFocus = hasFocus;
        this.isCellEditable = coloredTableModel.isCellEditable(modelrow, modelcolumn);

        //Textul ce se deseneaza
        if (value instanceof String) {
            this.setText((String)value);
        } else
        if (value instanceof BigDecimal) {
            BigDecimal auxBigDecimal = (BigDecimal) value;
            this.setText(NumberUtils.formatBigDecimal(auxBigDecimal,
                    coloredTableModel.getDecimalScale()));
        } else
        if (value instanceof Double) {
            Double auxDouble = (Double) value;
            this.setText(NumberUtils.formatDouble(auxDouble,
                    coloredTableModel.getDecimalScale()));
        } else
        if (value instanceof Integer) {
            Integer auxInteger = (Integer) value;
            this.setText(NumberUtils.formatInteger(auxInteger));
        }

        //Alinierea textului
        setVerticalAlignment(SwingConstants.TOP);
        if (value instanceof Number)
            setHorizontalAlignment(SwingConstants.RIGHT);
        else
            setHorizontalAlignment(SwingConstants.LEFT);

        //obtin tooltip textul
        String tooltipText;
        tooltipText = coloredTableModel
                .getTooltipText(modelrow,modelcolumn);

        //Setez tooltip textul
        this.setToolTipText(tooltipText);
        if (tooltipText != null) {
            hasToolTipText = true;
        } else {
            hasToolTipText = false;
        }

        //Setez culorile de desenare
        prefferedBackground = coloredTableModel.getBackground(modelrow);
        prefferedForeground = coloredTableModel.getForeground(modelrow);
        //~~~ Sel ~~~
        Color chosenBackground, chosenForeground;
        if (isSelected) {
            //Culoare speciala daca bg este suprascris
            chosenBackground = table.getSelectionBackground();
            chosenForeground = table.getSelectionForeground();
        } else {
            chosenBackground = prefferedBackground;
            chosenForeground = prefferedForeground;
        }

        //Desenez fundalul alternativ
        if (row % 2 == 0)
            setBackground(GraphicRenderingUtils.lightenColor(chosenBackground, colorOffset));
        else
            setBackground(GraphicRenderingUtils.darkenColor(chosenBackground, colorOffset));
        setForeground(chosenForeground);

        //Intorc aceasta componente
        return this;
    }

    /**
     * Aici printez starea la aceasta celula
     * @return
     */
    @Override
    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();

        //Variabile booleane puse la dispozitie de catre clasa
        stringBuffer.append("isSelected = "+isSelected); stringBuffer.append('\n');
        stringBuffer.append("hasSomeFocus = "+hasSomeFocus); stringBuffer.append('\n');
        stringBuffer.append("isCellEditable = "+isCellEditable); stringBuffer.append('\n');
        stringBuffer.append("hasToolTipText = "+hasToolTipText); stringBuffer.append('\n');

        //Variabile de stare
        stringBuffer.append("text = "+getText()); stringBuffer.append('\n');
        stringBuffer.append("background = "+getBackground()); stringBuffer.append('\n');
        stringBuffer.append("foreground = "+getForeground()); stringBuffer.append('\n');
        stringBuffer.append("prefferedBackground = "+prefferedBackground); stringBuffer.append('\n');
        stringBuffer.append("prefferedForeground = "+prefferedForeground); stringBuffer.append('\n');

        //Intorc stringul compus
        stringBuffer.append("==========================");
        return stringBuffer.toString();
    }
}
