/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package exenne.components.popup;

import java.awt.Component;
import java.awt.event.ActionListener;
import java.util.Hashtable;
import javax.swing.Icon;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;

/**
 * Clasa ce face managementul unui popul.
 * Poate sa activeze sau sa dezactiveze optiuni din mers
 * @author iulian
 */
public class JConfigurablePopup extends JPopupMenu {
    //Ascultatorul pe butoanele din meniu
    public ActionListener popupListener = null;

    //Hashtable-ul ce retine itemurile din meniu
    Hashtable<String, Component> items;

    /**
     * Constructorul popup-ului pentru selectie simpla
     * @param popupListener Ascultatorul pentru butoane
     */
    public JConfigurablePopup(ActionListener popupListener) {
        super();
        items = new Hashtable<String, Component>();
        this.popupListener = popupListener;
    }

    /**
     * Adauga un item la meniu si in hashtable
     * @param itemName Numele optiunii
     */
    public void addItem(String itemName, Icon icon){
        JMenuItem menuItem;
        menuItem = new JMenuItem(itemName);
        menuItem.setIcon(icon);
        menuItem.setActionCommand(itemName.toLowerCase());
        menuItem.addActionListener(popupListener);
        items.put(itemName, menuItem);
        this.add(menuItem);
    }

    /**
     * Adauga un item la meniu si in hashtable
     * @param itemName Numele optiunii
     */
    public void addItem(String itemName){
        this.addItem(itemName, null);
    }

    /**
     * Remove item from menu
     * @param itemName
     */
    public void removeItem(String itemName) {
        Component menuItem;
        menuItem = items.get(itemName);
        this.remove(menuItem);
        items.remove(itemName);
    }

    /**
     * Adauga un meniu la popup
     * @param menuName
     * @param menu
     */
    public void addMenu(JMenu menu) {
        items.put(menu.getName(), menu);
        this.add(menu);
    }

   /**
     * Adaug un separator cu nume
     */
    public void addNamedSeparator(String itemName) {
        int componentCount = this.getComponentCount();
        this.addSeparator();
        items.put(itemName, this.getComponent(componentCount));
    }

    /**
     * Activeaza un item
     * @param itemName Numele optiunii
     */
    public void setItemEnabled(String itemName) {
        Component menuItem;
        menuItem = items.get(itemName);
        if (menuItem!=null) menuItem.setEnabled(true);
    }

    /**
     * Dezactiveaza un item (il face gray)
     * @param itemName Numele optiunii
     */
    public void setItemDisabled(String itemName) {
        Component menuItem;
        menuItem = items.get(itemName);
        if (menuItem!=null) menuItem.setEnabled(false);
    }

    /**
     * Afiseaza un item in tabel
     * @param itemName Numele optiunii
     */
    public void setItemVisible(String itemName) {
        Component menuItem;
        menuItem = items.get(itemName);
        if (menuItem!=null) menuItem.setVisible(true);
    }

     /**
     * Ascunde un item din meniu
     * @param itemName Numele optiunii
     */
    public void setItemInvisible(String itemName) {
        Component menuItem;
        menuItem = items.get(itemName);
        if (menuItem!=null) menuItem.setVisible(false);
    }
}
