/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package exenne.components.treetable.undosupport;

import exenne.components.treetable.Treetable;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.UndoableEdit;

/**
 *
 * @author iulian
 */
public class InsertNodeToParentStandardUndoableEdit extends AbstractUndoableEdit {
    private Treetable treetable;

    //Definesc operatia
    private DefaultMutableTreeNode newNode;
    private DefaultMutableTreeNode parentNode;
    private int position;

    //Operatia de undo
    private UndoableEdit removeAction = null;

    /**
     * Actiune pentru stergerea unui nod
     * @param node
     */
    public InsertNodeToParentStandardUndoableEdit(Treetable treetable,
            DefaultMutableTreeNode newNode,
            DefaultMutableTreeNode parentNode, int position) {
        //Configurez operatia
        this.treetable = treetable;
        this.newNode = newNode;
        this.parentNode = parentNode;
        this.position = position;
    }

    /**
     * Executa actiunea in sine
     */
    public void execute() {
        DefaultTreeModel model = (DefaultTreeModel) treetable
                .getOutlineModel().getTreeModel();

        //1. Inserez nodul in parinte
        model.insertNodeInto(newNode, parentNode, position);

        //2. Ma asigur ca parintele este extins
        treetable.expandNode(parentNode);
    }

    /**
     * Actiunea de anulare a stergerii
     * @throws CannotUndoException
     */
    @Override
    public void undo() throws CannotUndoException {
        super.undo();

        //ma folosesc de operatia de stergere
        if (removeAction == null) {
            RemoveNodeFromParentStandardUndoableEdit localRemoveAction =
                    new RemoveNodeFromParentStandardUndoableEdit(treetable, newNode);
            localRemoveAction.execute();
            removeAction = localRemoveAction;
        } else {
            removeAction.redo();
        }
    }

    /**
     * Actiunea de refacere a
     * @throws CannotRedoException
     */
    @Override
    public void redo() throws CannotRedoException {
        super.redo();

        //ma folosesc de operatia de stergere
        removeAction.undo();
    }
}
