#include "../../headere/m1_hash_retrieval.h"

STRUCTURA_HASH* positionsForHash(unsigned int hashVal, int fd)
{
	//se pozitioneaza in fisier la locatia unde se gaseste valoarea offsetului la care sunt pozitiile
	//hashVal+1 pentru ca in afara de offseturi, in fisier se gaseste pe prima pozitie dimensiunea hash-ului
	//se inmulteste cu sizeof(unsigned int) pentru ca nu ne referim la octeti si la unsigned int
	if ( lseek(fd, (hashVal+1) * sizeof(unsigned int), SEEK_SET) == (off_t)-1)
		return NULL;
	unsigned int offsetValue = 0;
	//citesc offsetul de la care incep datele
	if ( read(fd, &offsetValue, sizeof(unsigned int)) == -1 )
		return NULL;
	//daca offsetul este 0, atunci pentru hash-ul respectiv nu se gaseste nimic in fisier
	if (offsetValue != 0)
	{
		//ma pozitionez la inceputul datelor; valoarea offsetului reprezinta pozitia absoluta in fisier unde se gasesc acestea
		if ( lseek(fd, offsetValue, SEEK_SET) == (off_t)-1 )
			return NULL;
		unsigned int numarValori = 0;
		if ( read(fd, &numarValori, sizeof(unsigned int)) == -1 )
			return NULL;
		STRUCTURA_HASH *structura = (STRUCTURA_HASH*)calloc(1, sizeof(STRUCTURA_HASH));
		if (structura == NULL)
			return NULL;
		structura->numar_aparitii = numarValori;
		structura->vector_pozitii = (unsigned long*)calloc(numarValori, sizeof(unsigned long));
		if ( structura->vector_pozitii == NULL )
		{
			free(structura);
			return NULL;
		}
		if ( read(fd, structura->vector_pozitii, numarValori * sizeof(unsigned long)) == -1 )
		{
			free(structura->vector_pozitii);
			free(structura);
			return NULL;
		}
		return structura;
	}
	return NULL;
}
