/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package ro.genomeartist.coloredtable.undosupport;

import ro.genomeartist.components.coloredtable.JColoredTable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableModel;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.UndoableEdit;

/**
 *
 * @author iulian
 */
public class PropertyUndoableEdit extends AbstractUndoableEdit {
    //Eveniment de proprietati
    private ActionEvent someAction =
            new ActionEvent(this, 0, "PropertyUndoableEdit");

    //Editarea unei valori in controller
    private JColoredTable table;
    private AbstractTableModel tableModel;
    private int modelRow;
    private UndoableEdit controllerAction;
    
    //Ascultatorul de actiune
    private ActionListener actionListener;

    /**
     * Construieste o actiune de undo
     * @param targetNode
     * @param controllerAction
     */
    public PropertyUndoableEdit(JColoredTable table, int modelRow,
            UndoableEdit controllerAction, ActionListener actionListener) {
        this.table = table;
        this.modelRow = modelRow;
        this.controllerAction = controllerAction;
        this.actionListener = actionListener;
        
        //Obtin modelul tabelului
        TableModel modelInterface = table.getModel();
        if (modelInterface instanceof AbstractTableModel) {
            tableModel = (AbstractTableModel) modelInterface;
        }
    }

    /**
     * Executa actualizarea 
     */
    public void notifyTable() {
        notifyTableModel();
    }
    
    /**
     * Executa actualizarea 
     */
    public void notifyListener() {
        notifyExternalListener();
    }
    
    
    /**
     * Operatia de undo
     * @throws CannotUndoException
     */
    @Override
    public void undo() throws CannotUndoException {
        super.undo();

        //1. Anulez actiunea din controller
        controllerAction.undo();

        //2. Notific modelul meu
        notifyActionPerformed();
    }

    /**
     * Operatia de redo
     * @throws CannotRedoException
     */
    @Override
    public void redo() throws CannotRedoException {
        super.redo();

        //1. Refac acctiunea din controller
        controllerAction.redo();

        //2. Notific modelul meu
        notifyActionPerformed();
    }
    
    /**~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
     *      Metode ajutatoare
     *~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/
    
    /**
     * Notific modelul tabelului
     */
    private void notifyTableModel() {
        if (tableModel != null)
            tableModel.fireTableRowsUpdated(modelRow, modelRow);
    }
    
    /**
     * Notific modelul tabelului
     */
    private void notifyExternalListener() {
        if (actionListener != null)
            actionListener.actionPerformed(someAction);
    }
    
    /**
     * Metoda apelata pentru notificare
     */
    private void notifyActionPerformed() {
        //1. Notific modelul meu
        notifyTableModel();

        //2. Fac selectia nodului care s-a modificat
        if (table != null) {
            int viewRow = table.convertRowIndexToView(modelRow);
            table.clearSelection();
            table.selectAndScrollToRow(viewRow);
        }

        //3. Notific modificarea pretului
        notifyExternalListener();
    } 
}