/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package ro.genomeartist.components.dropdownbutton;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import javax.swing.Icon;
import javax.swing.border.Border;

/**
 * Creez un border ce rendeaza o mica iconita pentru a marca meniul de dropdown
 * @author iulian
 */
public class MenuArrowBorder implements Border {
    private static final Icon ARROW_ICON = new MenuArrowIcon();;
    
    /**
     * COnstructor null
     */
    public MenuArrowBorder() {
    }

    /**
     * Metoda ce deseneaza efectiv borderul
     * @param c
     * @param g
     * @param x
     * @param y
     * @param width
     * @param height 
     */
    public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
        //Compute the position
        int icon_x = x + width-ARROW_ICON.getIconWidth()-4;
        int icon_y = y + (height-ARROW_ICON.getIconHeight())/2;
        
        //Desenez iconul
        ARROW_ICON.paintIcon(c, g, icon_x, icon_y);
    }

    /**
     * Obtin dimensiuniile adaugate de acest border
     * @param c
     * @return 
     */
    public Insets getBorderInsets(Component c) {
        return new Insets(0, 0, 0, ARROW_ICON.getIconWidth());
    }

    /**
     * Specifica daca borderul suprascrie setarile
     * @return 
     */
    public boolean isBorderOpaque() {
        return false;
    }
}