/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package ro.genomeartist.components.filechooser;

import ro.genomeartist.components.utils.FileUtils;
import java.io.File;
import javax.swing.filechooser.*;


/**
 * Clasa abstracta ce sta la baza fitrelor
 * @author iulian
 */
public abstract class AbstractSpecificFileFilter extends FileFilter {

    /**~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
     *    Metode abstracte (getteri)
     *~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/
    
    /**
     * Metoda ce specifica daca se accepta directoare
     * @return 
     */
    public abstract boolean isAcceptDirectory();
    
    /**
     * Metoda ce valideaza o anumita extensie
     * @param extension
     * @return 
     */
    public abstract boolean isExtensionValid(String extension);

    
    /**
     * Obtine extensia prefereata pentru salvare
     * @return 
     */
    public abstract String getPrefferedExtension();
    
    /**
     * Metoda ce obtine descrierea acestui filtru
     * @return 
     */
    public abstract String getDescription();
    
    /**~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
     *    Implementarea filtrului
     *~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/
    
    /**
     * Valideaza fisierele specificate
     * @param f
     * @return 
     */
    public boolean accept(File f) {
        //Cazul in care este director
        if (f.isDirectory()) {
            return isAcceptDirectory();
        }

        //Cazul in care e fisier
        String extension = FileUtils.getExtension(f);
        if (extension != null) {
            return isExtensionValid(extension);
        }

        //Valoarea default
        return false;
    }
    
    /**
     * Obtin un fisier care are extensia preferata de filtru
     * @param sourceFile
     * @return 
     */
    public File getFileWithPrefferedExtension(File sourceFile) {
        File newFile;
        
        //Convertesc extensia
        String basename = FileUtils.getBasename(sourceFile);
        basename += "."+getPrefferedExtension();
        newFile = new File(basename);
        
        //Intorc fisierul nou
        return newFile;
    }
}

