/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package ro.genomeartist.components.filechooser.filters;

import ro.genomeartist.components.filechooser.AbstractSpecificFileFilter;

/**
 *
 * @author iulian
 */
public class ImageSpecificFileFilter extends AbstractSpecificFileFilter {
    private static final String JPG = "jpg";
    private static final String PNG = "png";
    private static final String GIF = "gif";
    private static final String BMP = "gif";
    
    
    /**
     * Metoda ce specifica daca se accepta directoare
     * @return 
     */
    @Override
    public boolean isAcceptDirectory() {
        return true;
    }

    /**
     * Metoda ce valideaza o anumita extensie
     * @param extension
     * @return 
     */
    @Override
    public boolean isExtensionValid(String extension) {
        if ((JPG.compareToIgnoreCase(extension) == 0) ||
            (PNG.compareToIgnoreCase(extension) == 0) ||
            (GIF.compareToIgnoreCase(extension) == 0) ||
            (BMP.compareToIgnoreCase(extension) == 0)) {
            return true;
        }
        
        //Valoarea default
        return false;
    }
    
    /**
     * Obtine extensia prefereata pentru salvare
     * @return 
     */
    @Override
    public String getPrefferedExtension() {
        return JPG;
    }
    
    /**
     * Metoda ce obtine descrierea acestui filtru
     * @return 
     */
    public String getDescription() {
        StringBuilder stringBuilder = new StringBuilder();
        
        //Compun descrierea
        stringBuilder.append("Imagini (");
        stringBuilder.append(JPG).append(", ");
        stringBuilder.append(PNG).append(", ");
        stringBuilder.append(GIF).append(", ");
        stringBuilder.append(BMP).append(")");
        
        //Intorc stringul
        return stringBuilder.toString();
    }    
}

