/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package ro.genomeartist.components.jtable.rowheader.annotations;

import ro.genomeartist.components.jtable.rowheader.RowAnnotation;
import ro.genomeartist.components.jtable.rowheader.RunnableSuggestion;
import java.util.Vector;

/**
 * Clasa ce serveste drept model pentru implementarea de anotatii
 * @author iulian
 */
public abstract class AbstractRowAnnotation implements RowAnnotation {
    protected String tooltipText;
    protected Vector<RunnableSuggestion> suggestions;

    /**~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
     *       Constructor
     *~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/
    
    /**
     * Constructorul default
     */
    public AbstractRowAnnotation() {
        tooltipText = null;
        suggestions = null;
    }
    
    /**~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
     *  Getteri (Interfata RowAnnotation)
     *~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/

    /**
     * Obtin textul ce descrie anotatia
     * @return 
     */
    public String getTooltipText() {
        return tooltipText;
    }    
    
    /**
     * Obtin sugestiile pentru rezolvarea anotatiilor
     * @return 
     */
    public Vector<RunnableSuggestion> getSuggestions() {
        return suggestions;
    }
    
    /**~~~~~~~~~~~~~
     *  Setteri
     *~~~~~~~~~~~~~~*/

    /**
     * Sete tooltip textul
     * @param tooltipText 
     */
    public void setTooltipText(String tooltipText) {
        this.tooltipText = tooltipText;
    }    
    
    /**
     * Setez vectorul de sugestii
     * @param suggestions 
     */
    public void setSuggestions(Vector<RunnableSuggestion> suggestions) {
        this.suggestions = suggestions;
    }
}
