/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package ro.genomeartist.components.propertiespanel.editors;

import ro.genomeartist.components.propertiespanel.IEditorChangeListener;
import ro.genomeartist.components.propertiespanel.IPropertiesEditor;
import java.awt.BorderLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.SwingConstants;

/**
 *
 * @author iulian
 */
public class JButtonPropertiesEditor extends JPanel
        implements IPropertiesEditor, ActionListener {
    private Vector<IEditorChangeListener> editorChangeListeners;

    //Variabilele clasei
    private JButton mainButton;
    private Runnable runnable;

    /**~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
     *    Constructori
     *~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/

    /**
     * Creez un editor cu button cu textul specificat
     * @param buttonText 
     */
    public JButtonPropertiesEditor(String buttonText) {
        super();
        JButton button =  new JButton();
        button.setText(buttonText);
        init(button);
    }
    
    /**
     * Construiesc un editor folosind un buton specificat de utilizator
     * @param button 
     */
    public JButtonPropertiesEditor(JButton button) {
        super();
        init(button);
    }
    
    /**
     * Functia de initializare
     * @param button 
     */
    private void init(JButton button) {
        this.setLayout(new BorderLayout());

        //Creez componentele
        mainButton = button;
        runnable = null;

        //Setez butonul
        mainButton.setHorizontalAlignment(SwingConstants.CENTER);
        mainButton.addActionListener(this);

        //Setez panoul
        this.add(mainButton, BorderLayout.CENTER);

        //Initializez ascultatorii
        editorChangeListeners = new Vector<IEditorChangeListener>();
    }

    /**~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
     *    Se implementeaza interfata IPropertiesEditor
     *~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/

    /**
     * Obtin containerul global al editorului
     * @return
     */
    public JComponent getContainerComponent() {
        return this;
    }

    /**
     * Obtine componenta care realizeaza editarea propriu-zisa
     * @return
     */
    public JComponent getEditorComponent() {
        return mainButton;
    }

    /**
     * Seteaza numele componentei
     * @param name
     */
    @Override
    public void setEditorName(String name) {
        this.setName(name);
    }

    /**
    * Se seteaza valoarea ce se editeaza
    * @param objectClass
    * @param renderedObject
    */
    public void setValue(Class objectClass, Object renderedObject) {
        Runnable auxRunnable;

        //Setez obiectul in textfield
        if (Runnable.class == objectClass) {
            auxRunnable = (Runnable) renderedObject;
            runnable = auxRunnable;
        } else
            throw new UnsupportedOperationException(objectClass+" not supported in JColorIcon");
    }

    /**
     * Se obtione valoarea din textfield cu cast la clasa specificata
     * @param objectClass
     * @return
     */
    public Object getValue(Class objectClass) {
        //Obtin obiectul din textfield
        if (Runnable.class == objectClass) {
            return runnable;
        } else
            throw new UnsupportedOperationException(objectClass+" not supported in JColorIcon");
    }

    /**~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
     *   Managementul actiunilor
     *~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/

    /**
     * Aici primesc evenimente de la checkbox
     * @param e
     */
    public void actionPerformed(ActionEvent e) {
        //Execut actiunea specificata
        if (runnable != null)
            runnable.run();

        //Notific ascultatorii
        Iterator<IEditorChangeListener> iterator = editorChangeListeners.iterator();
        while (iterator.hasNext()) {
            IEditorChangeListener iEditorChangeListener = iterator.next();
            iEditorChangeListener.fireValueChanged();
        }
    }

    /**
     * Adaug un ascultator pentru schimbare valori
     * @param listener
     */
    public void addEditorChangeListener(IEditorChangeListener listener) {
        editorChangeListeners.add(listener);
    }

    /**
     * Deinregistrez un ascultator pentru schimbare valori
     * @param listener
     */
    public void removeEditorChangeListener(IEditorChangeListener listener) {
        editorChangeListeners.remove(listener);
    }
}
