/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package ro.genomeartist.components.propertiespanel.undecided;

import ro.genomeartist.components.utils.NumberUtils;

/**
 * Clasa ce reprezinta un big decimal nedecis.
 * @author iulian
 */
public class UndecidedInteger implements Comparable {
    private Integer integer;
    private boolean isUndecided;

    //Constanta pentru valoare indecisa
    public static final String UNDECIDED_STRING = "<valori diferite>";


    /**
     * Construiesc un big Decimal
     * @param integer
     */
    public UndecidedInteger(Integer integer) {
        setValue(integer);
    }

    /**
     * Construiesc cu un string
     * @param value
     */
    public UndecidedInteger(String value) {
        setValue(value);
    }

    /**~~~~~~~~~~~~~~~~~
     *      Getters
     *~~~~~~~~~~~~~~~~~~*/

    /**
     * Obtin BigDecimalul din spate
     * @return
     */
    public Integer getInteger() {
        return integer;
    }

    /**
     * Specifica daca respectiva valoare este nedecisa
     * @return
     */
    public boolean isUndecided() {
        return isUndecided;
    }

    /**
     * Specifica daca valoarea este decisa
     * @return
     */
    public boolean isDecided() {
        return !isUndecided;
    }

    /**~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
     *      Metode de comparatie nedecisa
     *~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/

    /**
     * Metoda de comparatie intre doua valori
     * @param o
     * @return
     */
    public int compareTo(Object o) {
        if (o instanceof UndecidedInteger) {
            UndecidedInteger compareInteger = (UndecidedInteger) o;
            if (this.isDecided() && compareInteger.isDecided() && integer != null)
                return integer.compareTo(compareInteger.getInteger());
            else return -1;
        } else throw new ClassCastException("Cannot compare");
    }

    /**
     * Compar doua obiecte indecise
     * @param obj
     * @return
     */
    @Override
    public boolean equals(Object obj) {
        if (obj instanceof UndecidedInteger) {
            UndecidedInteger compareInteger = (UndecidedInteger) obj;
            if (this.isDecided()) {
                assert integer != null : "Is is decided should not be null";

                if (compareInteger.isDecided()) {
                    return integer.equals(compareInteger.getInteger());
                }
                else return false;
            } else {
                if (compareInteger.isUndecided())
                    return true;
                else return false;
            }
        } else return false;
    }

    /**
     * Hash code
     * @return
     */
    @Override
    public int hashCode() {
        int hash = 5;
        hash = 29 * hash + (this.integer != null ? this.integer.hashCode() : 0);
        hash = 29 * hash + (this.isUndecided ? 1 : 0);
        return hash;
    }

    /**~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
     *      Metode de interactiune cu string
     *~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/

    /**
     * setez valoarea ca BigDecimal
     * @param value
     */
    public void setValue(Integer value) {
        if (value != null) {
            integer = value;
            isUndecided = false;
        } else {
            integer = null;
            isUndecided = true;
        }
    }

    /**
     * Setez valoarea ca string
     * @param value
     */
    public void setValue(String value) {
        Integer localIntegerValue;
        if (NumberUtils.isValidInteger(value)) {
            localIntegerValue = NumberUtils.toInteger(value);
        } else {
            localIntegerValue = null;
        }

        //Setez valoare bigDecimal
        setValue(localIntegerValue);
    }


    /**
     * Interfata externa a acestei clase este un string
     * @return
     */
    @Override
    public String toString() {
        if (this.isUndecided()) {
            return UNDECIDED_STRING;
        } else {
            return integer.toString();
        }
    }
}
