/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package ro.genomeartist.components.textfield.validator;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Component;
import java.awt.Composite;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import javax.swing.border.Border;

/**
 *
 * @author iulian
 */
public class ColorizingBorder implements Border {
    private final Border real;
    private Color backgroundColor;

    public ColorizingBorder(Border real, Color color) {
        this.real = real;
        this.backgroundColor = color;
    }

    public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
        if (real != null)
            real.paintBorder (c, g, x, y, width, height);
        g.setColor (backgroundColor);
        Graphics2D gg = (Graphics2D) g;
        Composite composite = gg.getComposite();
        AlphaComposite alpha = AlphaComposite.getInstance(AlphaComposite.SRC_OVER, 0.1F);
        try {
            gg.setComposite(alpha);
            gg.fillRect(x,y,width,height);
        } finally {
            gg.setComposite(composite);
        }
    }

    public Insets getBorderInsets(Component c) {
        if (real != null)
            return real.getBorderInsets(c);
        else return new Insets(0, 0, 0, 0);
    }

    public boolean isBorderOpaque() {
        return false;
    }
}