/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package ro.genomeartist.components.toolbar;

import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.border.Border;

/**
 * Wrapper peste butonul normal pentru a-l forta sa nu deseneze focusul
 * @author iulian
 */
public class JToolbarButton extends JButton {

    /**
     * Constructor cu un String
     * @param text
     */
    public JToolbarButton(String text) {
        super(text);
        configureButton();
    }

    /**
     * Constructor vid
     */
    public JToolbarButton() {
        configureButton();
    }

    /**
     * Dezactivez focusul pe butoanele din toolbar
     */
    private void configureButton() {
        //Se reseteaza borderul pentru ca JButton sa onoreze inseturile
        Border defaultBorder = this.getBorder();
        Border emptyBorder = BorderFactory.createEmptyBorder();
        Border compoundBorder = BorderFactory.createCompoundBorder(emptyBorder, defaultBorder);
        this.setBorder(compoundBorder);
        
        //Se fac setarile de afisare
        this.setFocusable(false);
        this.setFocusPainted(false);
        this.setRequestFocusEnabled(false);
        this.setRolloverEnabled(true);
        this.setBorderPainted(false);
    }
}
