/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package ro.genomeartist.components.utils;

import java.awt.AlphaComposite;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;

/**
 *
 * @author iulian
 */
public class ImageUtils {
    
    /**
     * Redimensiuneaza imagini, pastrand totusi aspect ratio
     * @param originalImage
     * @param width
     * @param height
     * @return 
     */
    public static BufferedImage resizeImage(BufferedImage originalImage, int width, int height) {
        BufferedImage resizedImage = new BufferedImage(width, height, BufferedImage.TYPE_4BYTE_ABGR);
	Graphics2D g2 = resizedImage.createGraphics();

        //Compute the ratio
        double width_ratio = ((float)width)/originalImage.getWidth();
        double height_ratio = ((float)height)/originalImage.getHeight(); 
        double ratio = Math.min(width_ratio, height_ratio);
        double newWidth = ratio * originalImage.getWidth();
        double newHeight = ratio * originalImage.getHeight();

        //Set rendering hints
	g2.setRenderingHint(RenderingHints.KEY_INTERPOLATION,
	RenderingHints.VALUE_INTERPOLATION_BILINEAR);
	g2.setRenderingHint(RenderingHints.KEY_RENDERING,
	RenderingHints.VALUE_RENDER_QUALITY);
	g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING,
	RenderingHints.VALUE_ANTIALIAS_ON);
        
        //Draw resized image
        int imageWidth = (int) newWidth;
        int imageHeight = (int) newHeight;
        int startX = (width - imageWidth)/2;
        int startY = (height - imageHeight)/2;
        g2.drawImage(originalImage, startX, startY, imageWidth, imageHeight, null);
	g2.dispose();	
	g2.setComposite(AlphaComposite.Src);

        //return the image
        return resizedImage;
    }
    
}
