/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package ro.genomeartist.gui.cellrenderers;
import ro.genomeartist.coloredtable.cellrenderers.DefaultColoredCellRenderer;
import ro.genomeartist.gui.interfaces.ICanPaint;
import java.awt.Component;
import java.awt.Graphics;
import javax.swing.JTable;

/**
 * Cell Renderer pentru un obiect de tip Partial Result
 * @author iulian
 */
public class JDefferPaintCellRenderer extends DefaultColoredCellRenderer {
    ICanPaint iCanPaint;

    /**
     * Constructor default
     */
    public JDefferPaintCellRenderer() {
        super();
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value,
            boolean isSelected, boolean hasFocus, int row, int column) {
        //Apelez parintele
        super.getTableCellRendererComponent(table, value, isSelected,
                hasFocus, row, column);

        this.iCanPaint = (ICanPaint) value;

        return this;
    }
    
    @Override
    public void paint(Graphics g) {
        //Desenez un partial result item
        iCanPaint.paint(g, getWidth(), getHeight(), getBackground(), getForeground());
    }
}
