/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package ro.genomeartist.gui.controller.externalcalls.actions;

import ro.genomeartist.components.swingworkers.progressworker.AbstractProgressCallable;
import ro.genomeartist.gui.controller.externalcalls.ExternalLink;
import ro.genomeartist.gui.controller.settings.SearchFile;
import ro.genomeartist.gui.controller.settings.SearchFolder;
import ro.genomeartist.gui.utils.MyUtils;
import java.io.File;
import java.util.Iterator;
import java.util.Vector;

/**
 *
 * @author iulian
 */
public class AddSearchFolderCallable extends AbstractProgressCallable<Vector<SearchFile>> {
    private SearchFolder searchFolderRaw;
    private boolean isTransposon;

    /**
     * Pastrez parametrii
     * @param searchFolderRaw
     * @param isTransposon
     */
    public AddSearchFolderCallable(SearchFolder searchFolderRaw, boolean isTransposon) {
        this.searchFolderRaw = searchFolderRaw;
        this.isTransposon = isTransposon;
    }


    /**
     * Fac actiunea propriu-zis
     * @return
     * @throws Exception
     */
    public Vector<SearchFile> call() throws Exception {
        Vector<SearchFile> newSearchFiles = new Vector<SearchFile>();

        //parse the folder
        Vector<File> rawFiles = ExternalLink.getSequencesFromFolder(searchFolderRaw.folderLocation);
        int numberOfSeqFile = rawFiles.size();
        int step = 100/numberOfSeqFile;
        int infLimit = 0;
        int supLimit = step;

        Iterator<File> fileIterator = rawFiles.iterator();
        while (fileIterator.hasNext()) {
            File rawFile = fileIterator.next();
            File geneFile = ExternalLink.getGeneFileForRaw(rawFile);

            //Creez un fisier nou
            SearchFile newSearchFile = new SearchFile();
            newSearchFile.fileTitle = searchFolderRaw.fileTitle+"_"+
                    MyUtils.getFilenameNoExt(rawFile);
            newSearchFile.rawLocation = rawFile;
            newSearchFile.geneLocation = geneFile;
            newSearchFile.isTransposon = isTransposon;

            //LAnsez actiunea de adaugare fisier
            this.setProgressRange(infLimit, supLimit);
            AbstractProgressCallable runDataHashing =
                    ExternalLink.getAddSearchFileCallable(newSearchFile);
            runDataHashing.setProgressInfoManager(this);
            runDataHashing.call();
            infLimit = supLimit;
            supLimit += step;

            //Adaug fisierul la tabel
            newSearchFiles.add(newSearchFile);
        }

        //intorc vectorul
        return newSearchFiles;
    }

}
