/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package ro.genomeartist.gui.controller.externalcalls.actions;

import ro.genomeartist.components.swingworkers.progressworker.AbstractProgressCallable;
import ro.genomeartist.gui.controller.externalcalls.ExternalLink;
import ro.genomeartist.gui.controller.settings.SearchFile;
import java.util.Iterator;
import java.util.Vector;

/**
 *
 * @author iulian
 */
public class DeleteMultipleFilesCallable extends AbstractProgressCallable<Boolean>{
    private Vector<SearchFile> deleteFilesVector;

    /**
     * Construiesc actiunea
     * @param deleteFilesVector
     */
    public DeleteMultipleFilesCallable(Vector<SearchFile> deleteFilesVector) {
        this.deleteFilesVector = deleteFilesVector;
    }


    /**
     * Fac actiunea propriu-zisa
     * @return
     * @throws Exception
     */
    public Boolean call() throws Exception {
        int filesNumber = deleteFilesVector.size();
        int step = 100/filesNumber;
        int infLimit = 0;
        int supLimit = step;

        Iterator<SearchFile> iteratorFisiere = deleteFilesVector.iterator();
        while (iteratorFisiere.hasNext()) {
            SearchFile searchFile = iteratorFisiere.next();

            this.setProgressRange(infLimit, supLimit);
            AbstractProgressCallable deleteIndividualFile =
                    ExternalLink.getDeleteSearchFileCallable(searchFile);
            deleteIndividualFile.setProgressInfoManager(this);
            deleteIndividualFile.call();
            infLimit = supLimit;
            supLimit += step;
        }

        //Default value
        return Boolean.TRUE;
    }

}
