/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package ro.genomeartist.gui.controller.externalcalls.actions;

import ro.genomeartist.components.swingworkers.progressworker.AbstractProgressCallable;
import ro.genomeartist.gui.controller.settings.SearchFile;
import java.io.File;

/**
 *
 * @author iulian
 */
public class DeleteSearchFileCallable extends AbstractProgressCallable<Boolean>{
    private SearchFile searchFile;

    /**
     * COnstruiesc actiunea de stergere
     * @param searchFile
     */
    public DeleteSearchFileCallable(SearchFile searchFile) {
        this.searchFile = searchFile;
    }

    /**
     * Fac actiunea propriu-zisa
     * @return
     * @throws Exception
     */
    public Boolean call() throws Exception {
        //Sterg fisierul de gene
        searchFile.geneLocation.delete();

        //Sterg fisierul .hash. Numele este identic cu fisierul .raw
        //doar ca are extensia .hash
        String pathRaw = searchFile.rawLocation.getPath();
        int indexOfPoint = pathRaw.lastIndexOf(".");
        if (indexOfPoint == -1) indexOfPoint = pathRaw.length();
        String pathHash = pathRaw.substring(0, indexOfPoint)+".hash";

        //Ma leg la fisierul .hash
        File hashLocation = new File(pathHash);

        //Sterg fisierele .raw si .hash
        hashLocation.delete();
        searchFile.rawLocation.delete();
        this.setProgressValue(100);

        //Default value
        return Boolean.TRUE;
    }

}
