/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package ro.genomeartist.gui.controller.externalcalls.actions;

import ro.genomeartist.components.swingworkers.progressworker.AbstractProgressCallable;
import ro.genomeartist.gui.controller.externalcalls.ExternalLink;
import ro.genomeartist.gui.utils.ReadOnlyConfiguration;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;

/**
 * Contruiesc o actiune callable ce masoara progresul
 * @author iulian
 */
public class RunDataHashingUtilityCallable extends AbstractProgressCallable<Boolean>{
    private File rawFile;

    /**
     * Constructorul principal
     * @param rawFile
     */
    public RunDataHashingUtilityCallable(File rawFile) {
        this.rawFile = rawFile;
    }


    /**
     * Actiunea propriu-zisa
     * @return
     * @throws Exception
     */
    public Boolean call() throws Exception {
       String args[]= new String[4];
       args[0] = ReadOnlyConfiguration.getString("hashingFile");
       args[1] = rawFile.getPath();
       args[2] = ExternalLink.PARAM_WINDOW_SIZE+"";
       args[3] = "single";

       ProcessBuilder pbuild;

        try {
            pbuild = new ProcessBuilder(args);
            Process process = pbuild.start();

            InputStream is = process.getInputStream();
            InputStreamReader isr = new InputStreamReader(is);
            BufferedReader br = new BufferedReader(isr);
            String line;

            //Citesc fisierul tinand cont de taguri
            this.setProgressRange(0, 100);
            TaggedFileConsumerCallable taggedFileConsumer =
                    new TaggedFileConsumerCallable(br, "end");
            taggedFileConsumer.setProgressInfoManager(this);
            taggedFileConsumer.call();
        } catch (IOException iOException) {
            System.err.println("Eroare la rulare data hashing utility");
            iOException.printStackTrace();
        }

       //Default value
       return Boolean.TRUE;
    }

}
