/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package ro.genomeartist.gui.controller.externalcalls.actions;

import ro.genomeartist.components.swingworkers.progressworker.AbstractProgressCallable;
import ro.genomeartist.components.utils.NumberUtils;
import ro.genomeartist.gui.utils.StringUtils;
import java.io.BufferedReader;
import java.util.regex.Pattern;

/**
 *
 * @author iulian
 */
public class TaggedFileConsumerCallable extends AbstractProgressCallable<Boolean> {
    //COnstante pentru taguri
    private static final Pattern REGEX_TAG =
            Pattern.compile("^@(\\w+)[\\s]*:[\\s]*([^:]*)");
    private static final String TAG_INFO = "info";
    private static final String TAG_PROGRESS = "progress";
    private static final String TAG_ERROR = "error";

    //Variabile de parametrii
    private BufferedReader br;
    private String stopWord;

    /**
     * Construiesc un consumator de fisiere taguite
     * @param br
     * @param stopWord
     */
    public TaggedFileConsumerCallable(BufferedReader br, String stopWord) {
        this.br = br;
        this.stopWord = stopWord;
    }


    /**
     * Metoda apelata pentru a face actiunea
     * @return
     * @throws Exception
     */
    public Boolean call() throws Exception {
        String line;
        while ((line = br.readLine()) != null) {
            if (line.startsWith(stopWord))
                break;
            
            //DEBUG, afisez
            //System.out.println(line);

            //Consume content
            String tag = StringUtils.regexFind(REGEX_TAG, line, 1);
            String value = StringUtils.regexFind(REGEX_TAG, line, 2);

            //System.out.println(line);
            if (tag != null && value != null) {
                if (TAG_INFO.equals(tag)) {
                    this.setProgressInfo(value);
                } else
                if (TAG_PROGRESS.equals(tag)) {
                    if (NumberUtils.isValidInteger(value))
                        this.setProgressValue(Integer.valueOf(value));
                } else
                if (TAG_ERROR.equals(tag)) {
                    this.addErrorMessage(value);
                }
            }
        }

        //default value
        return Boolean.TRUE;
    }


}
