/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package ro.genomeartist.gui.controller.genes;

import ro.genomeartist.gui.utils.ReadWriteConfiguration;

/**
 *
 * @author iulian
 */
public class GeneItem implements Comparable {
    private String name;           //Numele genei
    private String fisierOrigine;  //Bratul cromozomal pe care se afla
    public int locationStart;    //Pozitia de inceput
    public int locationEnd;    //Pozitia de sfarsit
    private boolean isComplement;          //Daca gena este pe catena complementare
    private String cyto;           //Regiunea cyto
    private String geneId;      //Id-ul flybase

    //###Display offset
    private int offset;


    /**
     * Constructorul
     */
    public GeneItem() {

        //Obtin offsetul de afisare a pozitiilor ( 0 sau +1)
        offset = Integer.parseInt((String)ReadWriteConfiguration.get("NUMBERING_OFFSET"));
    }

     /*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
      *      Getters and setters
      *~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/
    
    public String getCyto() {
        return cyto;
    }

    public void setCyto(String cyto) {
        this.cyto = cyto;
    }
    
    //~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~    

    public String getFisierOrigine() {
        return fisierOrigine;
    }

    public void setFisierOrigine(String fisierOrigine) {
        this.fisierOrigine = fisierOrigine;
    }

    //~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

    public String getGeneId() {
        return geneId;
    }

    public void setGeneId(String geneId) {
        this.geneId = geneId;
    }

    //~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

    public boolean isComplement() {
        return isComplement;
    }

    public void setIsComplement(boolean isComplement) {
        this.isComplement = isComplement;
    }

    //~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

    public int getLocationEnd() {
        return locationEnd + offset;
    }

    public void setLocationEnd(int locationEnd) {
        this.locationEnd = locationEnd;
    }

    //~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

    public int getLocationStart() {
        return locationStart + offset;
    }

    public void setLocationStart(int locationStart) {
        this.locationStart = locationStart;
    }

    //~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    //~~~~~~~~~~~~~~~~~~~~Ordinea naturala~~~~~~~~~~~~~~
    /**
     * Specifica ordinea naturala a obiectelor de tip geneItem
     * @param o
     * @return
     */
    public int compareTo(Object o) {
        if (o instanceof GeneItem) {
            GeneItem geneItem = (GeneItem) o;
            return this.name.compareToIgnoreCase(geneItem.name);
        } else throw new ClassCastException("Cannot compare");
    }

    @Override
    /**
     * Metoda standard de comparare a doua obiecte
     */
    public boolean equals(Object obj) {
        if (obj instanceof GeneItem) {
            int compareResult = this.compareTo(obj);
            if (compareResult == 0)
                return true;
            else return false;
        } else throw new ClassCastException("Cannot compare");
    }

    @Override
    public int hashCode() {
        int hash = 7;
        hash = 23 * hash + (this.name != null ? this.name.hashCode() : 0);
        return hash;
    }
}
