/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package ro.genomeartist.gui.controller.query;

import ro.genomeartist.gui.utils.DNAUtils;
import ro.genomeartist.gui.utils.StringUtils;


/**
 *
 * @author iulian
 */
public class SearchQuery {
    private String queryName;
    private String queryContent;

    /**~~~~~~~~~~~~~~~~~~~
     *    Consructori
     *~~~~~~~~~~~~~~~~~~~~~*/
    
    /**
     * Constructor
     */
    public SearchQuery() {
        this("", "");
    }
    
    /**
     * Constructor
     */
    public SearchQuery(String queryContent) {
        this("", queryContent);
    }
    
    /**
     * Constructor
     */
    public SearchQuery(String queryName, String queryContent) {
        this.queryName = queryName;
        this.queryContent = queryContent;
    }

    /**~~~~~~~~~~~~~~~~~~~
     *    Getteri
     *~~~~~~~~~~~~~~~~~~~~~*/
    
    /**
     * @return the queryName
     */
    public String getQueryName() {
        return queryName;
    }

    /**
     * @return the queryContent
     */
    public String getQueryContent() {
        return queryContent;
    }

    /**~~~~~~~~~~~~~~~~~~~
     *    Setteri
     *~~~~~~~~~~~~~~~~~~~~~*/
    
    /**
     * @param queryName the queryName to set
     */
    public boolean setQueryName(String queryName) {
        if (!StringUtils.areEqual(this.queryName, queryName)) {
            this.queryName = StringUtils.sanitizeName(queryName);
            return true;
        } else {
            return false;
        }
    }

    /**
     * @param queryContent the queryContent to set
     */
    public boolean setQueryContent(String queryContent) {
        if (!StringUtils.areEqual(this.queryContent, queryContent)) {
            this.queryContent = DNAUtils.sanitizeSequence(queryContent);
            return true;
        } else {
            return false;
        }
    }
}
