/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package ro.genomeartist.gui.controller.settings;

import java.util.Iterator;

/**
 *
 * @author iulian
 */
public class GeneralSettings {
    //Parametri de algoritm
    public AlgorithmParams algorithmParams;
    //Fisierele in care se cauta
    public SearchFileSet genomFiles;
    public SearchFileSet transposonFiles;


    /**
     * Incarca setarile din fisier
     */
    public void loadFromFile() {
        //Incarc algoritmii
        algorithmParams = new AlgorithmParams();
        algorithmParams.loadFromFile();

        //Incarc fisierele de genom si transposon
        genomFiles = new SearchFileSet();
        transposonFiles = new SearchFileSet();
        
        //Citesc fisierul de index
        SearchFileSet indexFisiere = new SearchFileSet();
        indexFisiere.loadFromFile();
        Iterator <SearchFile> iterator = indexFisiere.iterator();
        SearchFile itemFile;
        while (iterator.hasNext()) {
            itemFile = iterator.next();
            if (itemFile.isTransposon)
                transposonFiles.add(itemFile);
            else genomFiles.add(itemFile);
        }
    }

    /**
     * Salveaza setarile in fisiere
     * NU se reporneste serverul. Decat se face dump la configuratie pe disc
     */
    public void saveToFile() {
        if (algorithmParams != null)
            algorithmParams.saveToFile();

        SearchFileSet indexFisiere = new SearchFileSet(genomFiles);
        indexFisiere.addAll(transposonFiles);
        indexFisiere.saveToFile();
    }
}
