/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package ro.genomeartist.gui.dialogs;
import ro.genomeartist.gui.controller.partialresult.PartialResultItem;
import ro.genomeartist.gui.mainpanels.partialresult.JPartialResultItemPane;
import java.awt.*;
import java.awt.event.*;
import javax.swing.*;

/**
 *  Dialogul wrapper peste panoul cu afisearea unui Partial Result
 * @author iulian
 */
public class JPartialResultItemDialog extends JDialog {
    //Constante pentru dimensiuni
    private static final int FRAME_WIDTH = 600;
    private static final int FRAME_HEIGHT = 400;
    private static final int BUTTON_WIDTH = 100;

    private JPanel middlePane;
    private JPanel bottomPane;

    /**
     * Dialog de afisare partial result
     */
    public JPartialResultItemDialog(Frame owner, String title, boolean modal,
            PartialResultItem partialResultItem )  {
        super(owner, title, modal);
        setSize(FRAME_WIDTH,FRAME_HEIGHT);

        //Initialize the dialog
        setResizable(true);
        setDefaultCloseOperation(WindowConstants.HIDE_ON_CLOSE);
        setLayout(new BorderLayout());

        //Middle pane
        middlePane = new JPartialResultItemPane(partialResultItem);
        this.add(middlePane,BorderLayout.CENTER);

        //Making the buttons
        bottomPane = new JPanel();
            JButton button = new JButton("   Ok   ");
            button.setActionCommand("ok");
            button.addActionListener(buttonListener);
        bottomPane.add(button);
        this.add(bottomPane,BorderLayout.SOUTH);

        //Set it's location
        setLocationRelativeTo(owner);
    }

    /**
     *  <p style="margin-top: 0">
     *  Clasa ce reprezinta un ascultator pe butoanele de ok si Cancel
     *  </p>
     * @author iulian
     */
    ActionListener buttonListener = new ActionListener() {
        /**
         *  <p style="margin-top: 0">
         *  Invoked when an action occurs.
         *  </p>
         * @author iulian
         */
            public void actionPerformed(ActionEvent e)
            {
                String cmd = e.getActionCommand();
                if (cmd.equals("ok")) JPartialResultItemDialog.this.dispose();
            }
        };
}
