/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package ro.genomeartist.gui.mainpanels.genes;

import ro.genomeartist.gui.controller.genes.GeneItemWrapper;
import ro.genomeartist.gui.custompaint.JDefferedPanel;
import ro.genomeartist.gui.interfaces.IGlobalManager;
import java.awt.BorderLayout;
import javax.swing.BoxLayout;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;

/**
 *
 * @author iulian
 */
public class JGeneMappingPane extends JPanel {
    private IGlobalManager globalManager;
    private GeneItemWrapper geneItemWrapper;

    //Structura ferestrei
    private JSplitPane splitPane;
        private JDefferedPanel mappingPanel;
        private JGeneVectorPane geneSetPane;

    //Constante de afisare
    private static final int DIVIDER_LOCATION = 120;


    public JGeneMappingPane(IGlobalManager globalManager, GeneItemWrapper geneItemWrapper) {
        this.globalManager = globalManager;
        this.geneItemWrapper = geneItemWrapper;

        //Setez layout-ul
        setLayout(new BorderLayout());

        //Setez splitpane-ul
        splitPane = new JSplitPane(JSplitPane.VERTICAL_SPLIT);
        splitPane.setDividerLocation(DIVIDER_LOCATION);

        //Panou cu mapare gene
        mappingPanel = new JDefferedPanel(geneItemWrapper);
        splitPane.setTopComponent(new JScrollPane(mappingPanel));

        //Tabelul cu gene
        geneSetPane = new JGeneVectorPane(geneItemWrapper.getFullGeneVector());
        splitPane.setBottomComponent(geneSetPane);

        //Adaug splitpane-ul
        this.add(splitPane,BorderLayout.CENTER);
    }



}
