/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package ro.genomeartist.gui.mainpanels.settings;

import ro.genomeartist.gui.controller.settings.GeneralSettings;
import ro.genomeartist.gui.controller.settings.SearchFileSet;
import ro.genomeartist.gui.interfaces.IGlobalManager;
import javax.swing.JTabbedPane;

/**
 * Consturiesc panoul de setari
 * @author iulian
 */
public class JSettingsPane extends JTabbedPane {
    private GeneralSettings generalSettings;

    //Constante
    private static final String TEXT_PARAMS = "Parameters";
    private static final String TEXT_GENOM = "Genom files";
    private static final String TEXT_TRANSPOSON = "Transposon files";

    //Structura panoului
    JAlgorithmParametersPane algorithmParamsPane;
    JSearchFilesPane genomFilesPane;
    JSearchFilesPane transposonFilesPane;

    //Managerul global
    IGlobalManager globalManager;

    /**
     * Construiesc panoul de setari
     * @param generalSettings
     */
    public JSettingsPane(IGlobalManager globalManager,
            GeneralSettings generalSettings) {
        this.generalSettings = generalSettings;
        this.globalManager = globalManager;

            genomFilesPane = new JSearchFilesPane(globalManager, 
                    generalSettings.genomFiles, false);
        this.add(TEXT_GENOM,genomFilesPane);
            transposonFilesPane = new JSearchFilesPane(globalManager, 
                    generalSettings.transposonFiles, true);
        this.add(TEXT_TRANSPOSON,transposonFilesPane);
            algorithmParamsPane = new JAlgorithmParametersPane(generalSettings.algorithmParams);
        this.add(TEXT_PARAMS,algorithmParamsPane);
    }

    /**
     * Lansez actiunea de aplicare a schimbarilor de algoritmi
     * @return
     */
    public boolean fireActionApplyAlgorithmParams() {
        return algorithmParamsPane.commitChanges();
    }

    /**
     * Lansez actiunea de aplicare a schimbarilor de algoritmi
     * @return
     */
    public boolean fireActionApplyFileParams() {
        if (genomFilesPane.hasChanged() ||
                transposonFilesPane.hasChanged()) {
            SearchFileSet genomSet = genomFilesPane.getSearchFileSet();
            SearchFileSet transposonSet = transposonFilesPane.getSearchFileSet();
            SearchFileSet indexFisiere = new SearchFileSet(genomSet);
            indexFisiere.addAll(transposonSet);

            indexFisiere.saveToFile();

            return true;
        } else return false;
    }
    
}
