/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package ro.genomeartist.gui.reports.datasources;

import ro.genomeartist.gui.controller.genes.GeneItem;
import ro.genomeartist.gui.controller.genes.GeneVector;
import ro.genomeartist.gui.custompaint.DrawingConstants;
import java.math.BigDecimal;
import java.util.Iterator;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRField;

/**
 *
 * @author iulian
 */
public class JRDataSourceSubGenes implements JRDataSource {
        private GeneVector geneVector;
        private Iterator<GeneItem> iterator;
        private GeneItem geneItem;

        public JRDataSourceSubGenes(GeneVector geneVector) {
            this.geneVector = geneVector;
            iterator = geneVector.iterator();
        }


        public boolean next() throws JRException {
            if (iterator.hasNext()) {
                geneItem = iterator.next();
                return true;
            } else return false;
        }

        public Object getFieldValue(JRField jrField) throws JRException {
            String fieldName = jrField.getName();
            BigDecimal aux;
            int scale = 2;

             if ("sub_genes_name".equals(fieldName)) {
                 return geneItem.getName();
             } else
             if ("sub_genes_location".equals(fieldName)) {
                 return geneItem.getFisierOrigine();
             } else
             if ("sub_genes_cyto".equals(fieldName)) {
                 return geneItem.getCyto();
             } else
             if ("sub_genes_position".equals(fieldName)) {
                 return geneItem.getLocationStart()+".."+geneItem.getLocationEnd();
             } else
             if ("sub_genes_strand".equals(fieldName)) {
                 if (geneItem.isComplement())
                     return DrawingConstants.TEXT_STRAND_COMPLEMENTARY;
                 else return DrawingConstants.TEXT_STRAND_FORWARD;
             } else
             if ("sub_genes_id".equals(fieldName)) {
                 return geneItem.getGeneId();
             }  else {
                 System.out.println("fieldName = "+fieldName);
                throw new JRException("No field with specified name");
             }
        }
    }
