/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package ro.genomeartist.gui.reports.development;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Random;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRField;

/**
 *
 * @author iulian
 */
public class SubGenesTestDataSource implements JRDataSource {
        private Random rand = new Random(System.currentTimeMillis());
        private static final int LIMIT = 10;
        private int counter;
        private String f1,f2,f3,f4,f5,f6,f7;

        public SubGenesTestDataSource() {
            counter = 0;
            f1 = "gene";
            f2 = "dmel";
            f3 = "83b8-7B3B%";
            f4 = "12541123..122151512";
            f5 = "(+)";
            f6 = "FBgn02612451";
        }


        public boolean next() throws JRException {
            if (counter < LIMIT) {
                counter++;
                return true;
            } else return false;
        }

        public Object getFieldValue(JRField jrField) throws JRException {
            String fieldName = jrField.getName();
            BigDecimal aux;
            int scale = 2;

             if ("sub_genes_name".equals(fieldName)) {
                 return f1+"_"+counter;
             } else
             if ("sub_genes_location".equals(fieldName)) {
                 return f2+"_"+counter;
             } else
             if ("sub_genes_cyto".equals(fieldName)) {
                 return f3+"_"+counter;
             } else
             if ("sub_genes_position".equals(fieldName)) {
                 return f4;
             } else
             if ("sub_genes_strand".equals(fieldName)) {
                 return f5;
             } else
             if ("sub_genes_id".equals(fieldName)) {
                 return f6;
             }  else {
                 System.out.println("fieldName = "+fieldName);
                throw new JRException("No field with specified name");
             }
        }
    }
