/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package testing.probability;

/**
 *
 * @author iulian
 */
public abstract class ProbabilityAlgorithm {
    //Variabile de clasa
    protected int numberOfEvents;
    protected int numberOfConsecutiveHeads;
    protected double headProbability;

    /**
     * Construiesc o clasa pentru calculul probabilitatiilor
     * @param numberOfEvents
     * @param numberOfConsecutiveHeads
     * @param headProbability 
     */
    public ProbabilityAlgorithm(int numberOfEvents, 
            int numberOfConsecutiveHeads, double headProbability) {
        this.numberOfEvents = numberOfEvents;
        this.numberOfConsecutiveHeads = numberOfConsecutiveHeads;
        this.headProbability = headProbability;
    }

    /**~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
     *    Getteri publici
     *~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/
    
    /**
     * Numarul de evenimente
     */
    public int getNumberOfEvents() {
        return numberOfEvents;
    }    
    
    /**
     * Obtine numarul de evenimente consecutive cautat
     * @return 
     */
    public int getNumberOfConsecutiveHeads() {
        return numberOfConsecutiveHeads;
    }    
    
    /**
     * Obtine probabilitatea evenimetului pozitiv
     * @return 
     */
    public double getHeadProbability() {
        return headProbability;
    }

    /**~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
     *    Setteri publici
     *~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/
    
    /**
     * Seteaza numarul total de evenimente
     * @param numberOfEvents 
     */
    public void setNumberOfEvents(int numberOfEvents) {
        this.numberOfEvents = numberOfEvents;
    }    
    
    /**
     * Seteaza numarul de evenimente favorabile cautat
     * @param numberOfConsecutiveHeads 
     */
    public void setNumberOfConsecutiveHeads(int numberOfConsecutiveHeads) {
        this.numberOfConsecutiveHeads = numberOfConsecutiveHeads;
    }    
    
    /**
     * Seteaza probabilitatea evenimentului favorabil
     * @param headProbability 
     */
    public void setHeadProbability(double headProbability) {
        this.headProbability = headProbability;
    }
    
    /**~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
     *    Actiuni publice
     *~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/
    
    /**
     * Specifica daca o anumita configuratie este valida pentru algoritm
     * @param caseRepresentation
     * @return 
     */
    public abstract boolean isFavorableEventVector(EventVector eventVector);    
    
    /**
     * Calculeaza probabilitate conforma algoritmului propriu
     * @return 
     */
    public abstract double computeProbability();
}
