package exenne.components.coloredtable;

import exenne.components.headerrenderer.JHeaderSorterIcons;
import exenne.components.headerrenderer.MultilineHeaderRenderer;
import java.awt.Color;
import javax.swing.*;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import javax.swing.table.TableRowSorter;

public class JColoredTableTestClass {
    /**
     * Create the GUI and show it.  For thread safety,
     * this method should be invoked from the
     * event-dispatching thread.
     */
    private static void createAndShowGUI() {
        //Init look and feel
        initLookAndFeel();

        //Create and set up the window.
        JFrame frame = new JFrame("TableSelectionDemo");
        frame.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);

        //Test icons
        JHeaderSorterIcons iconProvider = new JHeaderSorterIcons();
        iconProvider.loadIcons();

        //Create and set up the content pane.
        AbstractColoredTableModel tableModel = new AbstractColoredTableModel() {

                @Override
                public Color getBackground(int row) {
                    return Color.CYAN;
                }

                @Override
                public Color getForeground(int row) {
                    return null;
                }

                public int getRowCount() {
                    return 10;
                }

                public int getColumnCount() {
                    return 3;
                }

                @Override
                public String getColumnName(int column) {
                    if (column >= 0)
                        return "column "+column;
                    else return null;
                }

                public Object getValueAt(int rowIndex, int columnIndex) {
                    return "["+rowIndex+","+columnIndex+"]";
                }

                /**
                 * Specifica Clasa pentru fiecare coloana
                 * @param column Coloana pentru care vreau tipul clasei
                 * @return Clasa coloanei
                 */
                @Override
                public Class getColumnClass(int column) {
                    switch (column) {
                    case 0:
                        return String.class;
                    case 1:
                        return String.class;
                    case 2:
                        return String.class;
                    default:
                        assert false;
                    }
                    return null;
                }

                @Override
                public boolean isCellEditable(int row, int col) {
                    switch (col) {
                        case 1:case 2:
                            return true;
                        default:
                            return false;
                    }
                }

                @Override
                public String getTooltipText(int row, int col) {
                    switch (col) {
                        case 0:case 1:
                            return "test";
                        default:
                            return null;
                    }
                }
            };
        JColoredTable coloredTable = new JColoredTable(tableModel);
        coloredTable.setRowHeight(coloredTable.getRowHeight());

        //Sorterul
        TableRowSorter tableSorter = new TableRowSorter<TableModel>(tableModel);
        coloredTable.setRowSorter(tableSorter);
        tableSorter.toggleSortOrder(0);

        //Incerc sa definesc latimea coloanelor
        MultilineHeaderRenderer multirenderer = new MultilineHeaderRenderer();
        TableColumn column; //coloana pe care lucrez
        TableColumnModel columns = coloredTable.getColumnModel();
        //Cod
        column = columns.getColumn(0);
        column.setHeaderRenderer(multirenderer);
        column.setPreferredWidth(100);
        //Descriere
        column = columns.getColumn(1);
        column.setHeaderRenderer(multirenderer);
        column.setPreferredWidth(200);
        //Cantitate
        column = columns.getColumn(2);
        column.setHeaderRenderer(multirenderer);
        column.setPreferredWidth(10);


        frame.add(new JScrollPane(coloredTable));

        //Display the window.
        frame.setSize(500, 500);
        frame.setLocationByPlatform(true);
        frame.setVisible(true);
    }


     /**
     *  <p style="margin-top: 0">
     *         Initializeaza Look and Feel. Default este cel al sistemului.
     *      </p>
     * @param titlu Titlul ferestrei
     * @author iulian
     */
    public static void initLookAndFeel() {
        String lookAndFeel = UIManager.getSystemLookAndFeelClassName();
        try {
            UIManager.setLookAndFeel(lookAndFeel);
        } catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static void main(String[] args) {
        //Schedule a job for the event-dispatching thread:
        //creating and showing this application's GUI.
        javax.swing.SwingUtilities.invokeLater(new Runnable() {
            public void run() {
                createAndShowGUI();
            }
        });
    }
}
