/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package exenne.components.jtable.rowheader;

import java.awt.Color;
import javax.swing.Icon;

/**
 * Pachetul de date ce se va renda intr-o celula de lista
 * @author iulian
 */
public class RowHeaderCellData {
    //Culori potrivite pentru panou
    public static final Color COLOR_LIGHT_RED = new Color(255,230,230);
    public static final Color COLOR_LIGHT_GREEN = new Color(230,255,230);
    public static final Color COLOR_LIGHT_BLUE = new Color(230,230,255);
    
    //Defaultul pentru culoare
    public static final Color DEFAULT_BACKGROUND = COLOR_LIGHT_BLUE;
    public static final Color DEFAULT_FOREGROUND = Color.BLACK;
    
    
    private String text;
    private String tooltipText;
    private Icon icon;
    private Color backgroundColor;
    private Color foregroundColor;

    /**
     * Construiesc un pachet de date
     * @param text 
     */
    public RowHeaderCellData() {
        this(null);
    }
    
    /**
     * Construiesc un pachet de date
     * @param text 
     */
    public RowHeaderCellData(String text) {
        this.text = text;
        this.tooltipText = null;
        this.icon = null;
        
        this.backgroundColor = DEFAULT_BACKGROUND;
        this.foregroundColor = DEFAULT_FOREGROUND;
    }
    
     /**~~~~~~~~~~~~~~~~~~~~~~~~~~~
     *   Setteri si Getteri
     *~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/
    
    /**
     * Obtin textul afisat
     * @return 
     */
    public String getText() {
        return text;
    }

    /**
     * Setez texxtul afisat
     * @param text 
     */
    public void setText(String text) {
        this.text = text;
    }

    /**
     * Setez tooltip textul
     * @return 
     */
    public String getTooltipText() {
        return tooltipText;
    }

    /**
     * Setez tooltip textul
     * @param tooltipText 
     */
    public void setTooltipText(String tooltipText) {
        this.tooltipText = tooltipText;
    }

    /**
     * Obtin iconul setat
     * @return 
     */
    public Icon getIcon() {
        return icon;
    }

    /**
     * Setez un icon in label
     * @param icon 
     */
    public void setIcon(Icon icon) {
        this.icon = icon;
    }
    
    /**
     * Obtin culoarea de fundal
     * @return 
     */
    public Color getBackgroundColor() {
        return backgroundColor;
    }

    /**
     * Setez culoarea de fundal
     * @param backgroundColor 
     */
    public void setBackgroundColor(Color backgroundColor) {
        this.backgroundColor = backgroundColor;
    }

    /**
     * Obtin culoarea scrisului
     * @return 
     */
    public Color getForegroundColor() {
        return foregroundColor;
    }

    /**
     * Setez culoarea scrisului
     * @param foregroundColor 
     */
    public void setForegroundColor(Color foregroundColor) {
        this.foregroundColor = foregroundColor;
    }

}
