/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package exenne.components.sidebar;

import java.awt.*;
import java.awt.event.*;
import javax.swing.*;

/**
 *  Implementeaza Un Border ce ofera informatii despre pozitia cursorului
 *  @author iulian
 */
public class JResizableBorder implements IResizableBorder{
    private int dist = 6;
    private int distS,distN,distW,distE;

    public JResizableBorder(int dist,int type){
        this.dist = dist;
        if ((type & NORTH) > 0) this.distN = dist;
        if ((type & SOUTH) > 0) this.distS = dist;
        if ((type & EAST) > 0) this.distE = dist;
        if ((type & WEST) > 0) this.distW = dist;
    }

    public Insets getBorderInsets(Component component){
        return new Insets(distN, distW, distS, distE);
    }

    public boolean isBorderOpaque(){
        return false;
    }

    /**
     * Aici se face desenarea Borderului.Poate fi schimbat in orice fel
     */
    public void paintBorder(Component component, Graphics g, int x, int y, int w, int h){
        g.setColor(Color.black);
        if (this.distW>0) g.drawLine(x+dist/2,y+2*dist,x+dist/2,y+h-2*dist);    //W line
        if (this.distE>0) g.drawLine(x+w-dist/2,y+2*dist,x+w-dist/2,y+h-2*dist);    //E line
        if (this.distN>0) g.drawLine(x+2*dist,y+dist/2,x+w-2*dist,y+dist/2);      //N line
        if (this.distS>0) g.drawLine(x+2*dist,y+h-dist/2,x+w-2*dist,y+h-dist/2);  //S line
    }

    /**
     * Aici se face interpretarea pozitiei. Se poate schimba in functie de
     * ce dorim sa oferim
     * @param me Evenimentul forwardat de care MouseListener
     * @return tipul cursorului
     */
    public int getResizeCursor(MouseEvent me){
        Component comp = me.getComponent();
        Point point = me.getPoint();
        Rectangle rect;
        int w = comp.getWidth();
        int h = comp.getHeight();

        rect = new Rectangle(0, distN, distW, h-distN-distS);
        if (rect.contains(point))
            return Cursor.W_RESIZE_CURSOR;

        rect = new Rectangle(w-distE, distN, distE, h-distN-distS);
        if (rect.contains(point))
            return Cursor.E_RESIZE_CURSOR;

        rect = new Rectangle(distW, 0, w-distW-distE, distN);
        if (rect.contains(point))
            return Cursor.N_RESIZE_CURSOR;

        rect = new Rectangle(distW, h-distS, w-distW-distE, distS);
        if (rect.contains(point))
            return Cursor.S_RESIZE_CURSOR;

        return Cursor.DEFAULT_CURSOR;
    }
}