/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package exenne.components.treetable;

import exenne.components.treetable.Treetable;
import java.util.Iterator;
import java.util.Stack;
import java.util.Vector;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.tree.AbstractLayoutCache;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;

/**
 * Ascultatorul de selectie pentru un treetable
 * @author iulian
 */
public class TreetableListSelectionHandler implements ListSelectionListener {
    private Treetable outline;
    Stack<Integer> selectionMarkers;
    Vector<TreetableSelectionListener> selectionListeners;

    /**
     * Construiesc un ascultator de selectie
     * @param outline
     */
    public TreetableListSelectionHandler(Treetable outline) {
        this.outline = outline;
        selectionMarkers = new Stack<Integer>();
        selectionListeners = new Vector<TreetableSelectionListener>();
    }

     /**~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
     *      Managementul listenerilor
     *~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/

    /**
     * Adaug listenerul utilizatorului
     */
    public void addSelectionListener(TreetableSelectionListener selectionListener) {
        selectionListeners.add(selectionListener);
    }

    /**
     * Adaug listenerul utilizatorului
     */
    public void removeSelectionListener(TreetableSelectionListener selectionListener) {
        selectionListeners.remove(selectionListener);
    }

    /**
     * Lansez evenimentul in listeneri
     */
    private void notifyListeners() {
        Iterator <TreetableSelectionListener> listeners = selectionListeners.iterator();
        while(listeners.hasNext()) {
            TreetableSelectionListener listener = listeners.next();
            listener.selectionChanged();
        }
    }

     /**~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
     *      Capturarea selectiei
     *~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/

    /**
     * La selectia unui nod de arbore, declansez redesenarea tutoror copiilor afisati
     * @param e
     */
    public void valueChanged(ListSelectionEvent e) {
        int[] sels = null;
        boolean en = outline.getSelectedRow() != -1;
        ListSelectionModel m = outline.getSelectionModel();
        //en = (m.getMinSelectionIndex() != m.getMaxSelectionIndex());
        en = outline.getSelectedNode() != null;
        if (en) {
            DefaultMutableTreeNode nd = outline.getSelectedNode();
            en = nd.getChildCount() > 1;
        }
        en = outline.getSelectedNode() != null;
        if (en) {
            sels = outline.getSelectedIndices();
            en = sels.length > 1;
            if (sels.length > outline.getRowCount()) {
                en = false;
            }
            if (en) {
                DefaultMutableTreeNode lastParent = null;
                for (int i = 0; i < sels.length; i++) {
                    DefaultMutableTreeNode nd = (DefaultMutableTreeNode)
                            outline.getValueAt(sels[i], 0);
                    if (nd == null) {
                        en = false;
                        break;
                    }
                    if (lastParent != null) {
                        en &= nd.getParent() == lastParent;
                        if (!en) {
                            break;
                        }
                    } else {
                        lastParent = (DefaultMutableTreeNode) nd.getParent();
                    }
                }
            }
        }


        //BEGIN Issue #2 - Selectia unei norme -
        //Verific daca a fost deselectat ceva
        Integer prevoiusRow;
        Object phony;
        DefaultMutableTreeNode node;
        while (!selectionMarkers.empty())
        {
            //Redesenez randul
            prevoiusRow = selectionMarkers.pop();
            outline.repaintRow(prevoiusRow);

            //Redesenez si toti copii randului selectat
            AbstractLayoutCache layout = outline.getLayoutCache();
            TreePath path = layout.getPathForRow(prevoiusRow);
            int visibleChildCount = layout.getVisibleChildCount(path);
            //Redesenez nodurile
            int row_index;
            for (int j = 0; j < visibleChildCount; j++) {
                row_index = prevoiusRow+j+1;
                outline.repaintRow(row_index);
            }
        }

        //sels contine indicii elementelor selectate sau null daca este deselectie
        AbstractLayoutCache layout = outline.getLayoutCache();
        int row_index;

        //iterez prin nodurile selectate si vad daca sunt extended
        if (sels!=null)
            for (int i=0;i<sels.length;i++) {
                //Retine selectia pe stiva
                selectionMarkers.add(sels[i]);

                //Determina cati copii are randul selectat
                TreePath path = layout.getPathForRow(sels[i]);
                int visibleChildCount = layout.getVisibleChildCount(path);

                //Redesenez nodurile
                for (int j = 0; j < visibleChildCount; j++) {
                row_index = sels[i]+j+1;
                outline.repaintRow(row_index);
                }
            }
        //END Issue#2

        //Activez meniurile in functie de ce este selectat
        notifyListeners();
    }

    /**
     * Resetez listenerul la starea initiala
     */
    public void reset() {
        selectionMarkers.empty();
    }

     /**~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
     *      Metode ajutatoare (Utils)
     *~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/

    /**
     * Obtin numarul de copii vizibil ai unui nod
     * @param node
     */
    private int getVisibleChildCount(DefaultMutableTreeNode node) {
        int visibleChilds = 0;
        
        AbstractLayoutCache layout = outline.getLayoutCache();
        return 0;
    }
}
