/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package exenne.components.treetable.warningrowbar;

import exenne.components.jtable.rowheader.RowHeaderCellData;
import java.util.Vector;
import javax.swing.Icon;

/**
 * Clasa cu date despre starea celulei
 * @author iulian
 */
public class WarningBarCellData  extends RowHeaderCellData {
    //Constante
    public static final int STATE_CLEAR = 0;
    public static final int STATE_WARNING = 1;
    public static final int STATE_FATAL = 2;
    
    //Variabile de clasa
    private int state;
    private Vector<RunnableSuggestion> suggestions;
    
    //Icon provider
    private JWarningBarIcons iconProvider;
    
    /**
     * Constructorul principal
     */
    public WarningBarCellData() {
        super();

        //Initializarile default
        this.state = STATE_CLEAR;
        this.suggestions = null;
        
        //Initializez icon providerul
        iconProvider = JWarningBarIcons.getInstance();
    }
    
    
     /**~~~~~~~~~~~~~~~~~~~~~~~~~~~
     *   Suprascrieri
     *~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/
    
    /**
     * Se afiseaza text doar cand este liber ecranul
     * @return 
     */
    @Override
    public String getText() {
        if (state == STATE_CLEAR)
            return super.getText();
        else return null;
    }

    /**
     * Se afiseaza tooltip doar cand sunt probleme
     * @return 
     */
    @Override
    public String getTooltipText() {
        if (state == STATE_CLEAR)
            return null;
        else
            return super.getTooltipText();
    }

    /**
     * Obtin iconul aferent starii celulei
     * @return 
     */
    @Override
    public Icon getIcon() {
        switch (state) {
            case STATE_WARNING:
                if (suggestions != null && !suggestions.isEmpty())
                    return iconProvider.getIcon(JWarningBarIcons.WARNING_SUGGESTION);
                else return iconProvider.getIcon(JWarningBarIcons.WARNING);
            case STATE_FATAL:
                if (suggestions != null && !suggestions.isEmpty())
                    return iconProvider.getIcon(JWarningBarIcons.FATAL_SUGGESTION);
                else return iconProvider.getIcon(JWarningBarIcons.FATAL);
            default:
                return super.getIcon();           
        }
    }

     /**~~~~~~~~~~~~~~~~~~~~~~~~~~~
     *   Setteri si Getteri
     *~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/
    
    /**
     * Obtin starea celulei
     * @return 
     */
    public int getState() {
        return state;
    }

    /**
     * Setez starea celulei
     * @param state 
     */
    public void setState(int state) {
        this.state = state;
    }

    /**
     * Obtin sugestiile
     * @return 
     */
    public Vector<RunnableSuggestion> getSuggestions() {
        return suggestions;
    }

    /**
     * Setez sugestiile
     * @param suggestions 
     */
    public void setSuggestions(Vector<RunnableSuggestion> suggestions) {
        this.suggestions = suggestions;
    }
}
