/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package exenne.components.dropdownbutton;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JPopupMenu;
import javax.swing.JToggleButton;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;

/**
 *
 * @author iulian
 */
public class JDropDownButton extends JToggleButton {
    private static final Icon i = new MenuArrowIcon();
    protected JPopupMenu pop;

    public JDropDownButton(JPopupMenu popup) {
        this("", null,popup);
    }
    public JDropDownButton(Icon icon,JPopupMenu popup) {
        this("", icon,popup);
    }
    public JDropDownButton(String text,JPopupMenu popup) {
        this(text, null,popup);
    }
    public JDropDownButton(String text, Icon icon,JPopupMenu popup) {
        super();

        //Seteaza popupul
        setPopupMenu(popup);

        Action a = new AbstractAction(text) {
            public void actionPerformed(ActionEvent ae) {
                JDropDownButton b = (JDropDownButton)ae.getSource();
                if(pop!=null) pop.show(b, 0, b.getHeight());
            }
        };
        a.putValue(Action.SMALL_ICON, icon);
        setAction(a);
        setFocusable(false);
        setBorderPainted(false);
        setMargin(new Insets(0, 0, 0, 2+i.getIconWidth()));
    }
    
    public void setPopupMenu(JPopupMenu pop) {
        this.pop = pop;
        pop.addPopupMenuListener(new PopupMenuListener() {
            public void popupMenuCanceled(PopupMenuEvent e) {}
            public void popupMenuWillBecomeVisible(PopupMenuEvent e) {}
            public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
                setSelected(false);
            }
        });
    }


    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        Dimension dim = getSize();
        Insets ins = getInsets();
        int x = dim.width-i.getIconWidth()-4;
        int y = ins.top+(dim.height-ins.top-ins.bottom-i.getIconHeight())/2;
        i.paintIcon(this, g, x, y);
    }
}