/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package exenne.components.coloredtable.cellrenderers;

import exenne.components.utils.GraphicRenderingUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import javax.swing.BorderFactory;
import javax.swing.JTable;
import javax.swing.SwingConstants;
import javax.swing.border.Border;

/**
 * Implementarea default a cellRenderului
 * @author iulian
 */
public class DefaultColoredCellRenderer extends AbstractColoredCellRenderer {

    //Border pentru reprezentare tooltip
    private Border tooltipBorder;


    public DefaultColoredCellRenderer() {
        super();

        tooltipBorder = new TableTooltipBorder();
    }

    /** Overridden to combine the expansion border (whose insets determine how
     * much a child tree node is shifted to the right relative to the ancestor
     * root node) with whatever border is set, as a CompoundBorder.  The expansion
     * border is also responsible for drawing the expansion icon.  */
    @Override
    public void setBorder(Border b) {
        if (b == tooltipBorder) {
            super .setBorder(b);
        } else {
            super .setBorder(BorderFactory.createCompoundBorder(tooltipBorder,
                    b));
        }
    }

    //~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~/
    //      Clase de desenare
    //~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~/

    @Override
    public Component getTableCellRendererComponent(JTable table,
            Object value, boolean isSelected, boolean hasFocus,
            int row, int column) {

        //Setez parametrii in parinte
        super.getTableCellRendererComponent(table, value,
                isSelected, hasFocus, row, column);

        //DEBUG
        //if (hasFocus)
        //    System.out.println(this);


        //Intorc aceasta componenta pentru a-i suprascrie paintul
        return this ;
    }

    /**
     * Suprascriu paintul pentru a putea desena celulele editabile
     * @param g
     */
    @Override
    public void paint(Graphics g) {
        Graphics2D g2d = (Graphics2D) g;
        int width = getWidth();
        int height = getHeight();
        int startX,startY;
        int focusMarkerSize = 4;
        int iconWidth = 16;

        //Culorile
        Color actualBgColor, actualFgColor; //Culoarea setata in pregatiri
        actualBgColor = getBackground();
        actualFgColor = getForeground();
        Color prefferedBgColor, prefferedFgColor;
        prefferedBgColor = getPrefferedBackground();
        prefferedFgColor = getPrefferedForeground();

        //Desenez backgroundul
        g2d.setColor(actualBgColor);
        g2d.fillRect(0, 0, width, height);
        setBackground(null);

        //Caz special daca celula este editabila
        if (isCellEditable()) {
            boolean isLeftAligned = getHorizontalAlignment() == SwingConstants.LEFT ||
                    getHorizontalAlignment() == SwingConstants.LEADING;

            //Aleg culorile pentru desenare
            Color colorLeft;
            Color colorRight;
            if (isSelected()) {
                colorLeft = g2d.getColor();
                colorRight = GraphicRenderingUtils.lightenColor(colorLeft, 2*getColorOffset());
            } else {
                colorLeft = g2d.getColor();
                colorRight = Color.WHITE;
            }

            //Fac desenarea propriu-zisa
            GraphicRenderingUtils.drawEditableBackground(g2d,colorLeft,
                    colorRight,width,height,iconWidth,isLeftAligned);

            //Invalidez fundalul
            setBackground(null);
        }

        //Desenez focusul
        if (hasSomeFocus()) {
            g2d.setColor(actualFgColor);

            //Stanga - Sus
            startX = 0;
            startY = 0;
            g2d.drawLine(startX, startY,
                    startX, focusMarkerSize);
            g2d.drawLine(startX, startY,
                    focusMarkerSize, startY);

            //Stanga - Jos
            startX = 0;
            startY = height-1;
            g2d.drawLine(startX, startY,
                    startX, startY-focusMarkerSize);
            g2d.drawLine(startX, startY,
                    focusMarkerSize, startY);

            //Dreapta - Jos
            startX = width-1;
            startY = height-1;
            g2d.drawLine(startX, startY,
                    startX, startY-focusMarkerSize);
            g2d.drawLine(startX, startY,
                    startX-focusMarkerSize, startY);

            //Dreapta - Sus
            startX = width-1;
            startY = 0;
            g2d.drawLine(startX, startY,
                    startX, focusMarkerSize);
            g2d.drawLine(startX, startY,
                    startX-focusMarkerSize, startY);
        }

        super.paint(g);
    }
}
