/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package exenne.components.miscellaneous.labellines;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.border.Border;

/**
 *
 * @author iulian
 */
public class JLinkButton extends JButton {
    private static final Color LINK_COLOR = Color.blue;
    private static final Border LINK_BORDER = BorderFactory.createEmptyBorder(0, 0, 1, 0);
    private static final Border HOVER_BORDER = BorderFactory.createMatteBorder(0, 0, 1, 0, LINK_COLOR);

      /**~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
      *    Constructori
      *~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/
    
    /**
     * Se forwardeaza call-ul catre parinte
     * @param text
     * @param icon 
     */
    public JLinkButton(String text, Icon icon) {
        super(text, icon);
        initializeButton();
    }

    /**
     * Se forwardeaza call-ul catre parinte
     * @param text
     * @param icon 
     */
    public JLinkButton(Action a) {
        super(a);
        initializeButton();
    }

    /**
     * Se forwardeaza call-ul catre parinte
     * @param text
     * @param icon 
     */
    public JLinkButton(String text) {
        super(text);
        initializeButton();
    }

    /**
     * Se forwardeaza call-ul catre parinte
     * @param text
     * @param icon 
     */
    public JLinkButton(Icon icon) {
        super(icon);
        initializeButton();
    }

    /**
     * Se forwardeaza call-ul catre parinte
     * @param text
     * @param icon 
     */
    public JLinkButton() {
        initializeButton();
    }
    
    /**
     * Functia ce face initializarea propriu-zisa
     */
    private void initializeButton() {
        this.setBorder(LINK_BORDER);
        this.setForeground(LINK_COLOR);
        this.setCursor(Cursor.getPredefinedCursor(Cursor.HAND_CURSOR));
        this.setFocusPainted(false);
        this.setRequestFocusEnabled(false);
        this.setContentAreaFilled(false);
        this.addMouseListener(new LinkMouseListener());
    }
    
      /*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
      *   Listener de mouse
      *~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/
    
    private static class LinkMouseListener extends MouseAdapter{
        @Override
        public void mouseEntered(MouseEvent e){
            ((JComponent)e.getComponent()).setBorder(HOVER_BORDER);
        }

        @Override
        public void mouseReleased(MouseEvent e){
            ((JComponent)e.getComponent()).setBorder(LINK_BORDER);
        }

        @Override
        public void mouseExited(MouseEvent e){
            ((JComponent)e.getComponent()).setBorder(LINK_BORDER);
        }
    };
    
}
