/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package exenne.components.tree.search;

import java.util.Enumeration;
import java.util.NoSuchElementException;
import javax.swing.tree.DefaultMutableTreeNode;

/**
 * Contruiesc o enumeratie pentru parcurgerea nodurilor inainte
 * @author iulian
 */
public class ForwardNodeTraversal implements Enumeration<DefaultMutableTreeNode> {
    private DefaultMutableTreeNode targetNode;
    private DefaultMutableTreeNode currentNode;
    private DefaultMutableTreeNode nextNode;
    boolean includeHead;
    
    /**
     * Constructor cu includeHead = true;
     * @param targetNode 
     */
    public ForwardNodeTraversal(DefaultMutableTreeNode targetNode) {
        this(targetNode, true);
    }
    
    /**
     * Contruiesc clasa de parcurgere
     * @param targetNode 
     */
    public ForwardNodeTraversal(DefaultMutableTreeNode targetNode, boolean includeHead) {
        this.targetNode = targetNode;
        this.currentNode = null;
        this.nextNode = computeNextElement(targetNode);
        this.includeHead = includeHead;
    }

    /**~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
     *      Metodele ajutatoare pentru iterare
     *~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/
    
    /**
     * Obtin elementul frate al nodului curent chiar daca este pe nivel diferit
     * @param currentNode
     * @return 
     */
    private DefaultMutableTreeNode getNextSubsrootedSibling(DefaultMutableTreeNode currentNode) {
        if (currentNode == null) {
            return null;
        } else {
            DefaultMutableTreeNode nextSibling = currentNode.getNextSibling();
            if (nextSibling != null)
                return nextSibling;
            else
                return getNextSubsrootedSibling((DefaultMutableTreeNode)currentNode.getParent());
        }
    }
    
    /**
     * Obtin noul element 
     * @return 
     */
    private DefaultMutableTreeNode computeNextElement(
            DefaultMutableTreeNode currentNode) {
        if (currentNode.getChildCount() != 0) {
            return (DefaultMutableTreeNode) currentNode.getFirstChild();
        } else {
            DefaultMutableTreeNode nextRootSibling = getNextSubsrootedSibling(currentNode);
            if (nextRootSibling != null)
                return nextRootSibling;
            else
                return (DefaultMutableTreeNode) currentNode.getRoot();
        }
    }
    
    /**~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
     *      Metodele publice ale enumeratiei
     *~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/
    
    /**
     * Metoda care intreaba daca mai sunt elemente
     * @return 
     */
    public boolean hasMoreElements() {
        if (nextNode != null) {
            if (includeHead) {
                if (targetNode.equals(currentNode))
                    return false;
            } else {
                if (targetNode.equals(nextNode))
                    return false;
            }
            
            //A trecut toate testele
            return true;
        } else {
            return false;
        }
    }

    /**
     * Avansez iteratorul cu un element
     * @return 
     */
    public DefaultMutableTreeNode nextElement() {
        if (hasMoreElements()) {
            currentNode = nextNode;
            nextNode = computeNextElement(currentNode);

            return currentNode;
        } else {
            throw new NoSuchElementException("No more nodes");
        }
    }
    
    /**~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
     *     Metoda de test
     *~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/
    
    /**
     * Metoda de test
     * @param args 
     */
    public static void main(String[] args) {
        DefaultMutableTreeNode rootNode = new DefaultMutableTreeNode("rootNode");
        DefaultMutableTreeNode child1 = new DefaultMutableTreeNode("child1");
            DefaultMutableTreeNode child1_1 = new DefaultMutableTreeNode("child1_1");
            DefaultMutableTreeNode child1_2 = new DefaultMutableTreeNode("child1_2");
            DefaultMutableTreeNode child1_3 = new DefaultMutableTreeNode("child1_3");
        DefaultMutableTreeNode child2 = new DefaultMutableTreeNode("child2");
            DefaultMutableTreeNode child2_1 = new DefaultMutableTreeNode("child2_1");
        DefaultMutableTreeNode child3 = new DefaultMutableTreeNode("child3");
            DefaultMutableTreeNode child3_1 = new DefaultMutableTreeNode("child3_1");
            DefaultMutableTreeNode child3_2 = new DefaultMutableTreeNode("child3_2");
            
        //Fac arborele
        rootNode.add(child1);
            child1.add(child1_1);
            child1.add(child1_2);
            child1.add(child1_3);
        rootNode.add(child2);
            child2.add(child2_1);
        rootNode.add(child3);
            child3.add(child3_1);
            child3.add(child3_2);
            
        Enumeration<DefaultMutableTreeNode> nodeTraversal = new ForwardNodeTraversal(rootNode);
        while (nodeTraversal.hasMoreElements()) {
            DefaultMutableTreeNode defaultMutableTreeNode = nodeTraversal.nextElement();
            String item = (String) defaultMutableTreeNode.getUserObject();
            System.out.println(item);
        }
    }
}
