/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package exenne.components.coloredtable.cellrenderers;

import exenne.components.treetable.cellrenderers.*;
import exenne.components.treetable.JHandleIcons;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Component;
import java.awt.Composite;
import java.awt.Graphics2D;
import java.awt.Insets;
import javax.swing.Icon;
import javax.swing.SwingConstants;
import javax.swing.border.Border;

/**
 *
 * @author iulian
 */
public class TableTooltipBorder implements  Border {
    private Insets insets = new Insets(0, 0, 0, 0);
    private Icon tootlipIcon;

    public TableTooltipBorder() {
        super();

        JHandleIcons iconProvider = JHandleIcons.getInstance();
        tootlipIcon = iconProvider.getIcon(JHandleIcons.TOOLTIP);
    }

    public Insets getBorderInsets(Component c) {
        AbstractColoredCellRenderer ren = (AbstractColoredCellRenderer) c;
        if (ren.hasToolTipText()) {
            int halignment = ren.getHorizontalAlignment();
            if (halignment == SwingConstants.RIGHT) {
                insets.left = tootlipIcon.getIconWidth();
                insets.top = 0;
                insets.right = 0;
                insets.bottom = 0;
            } else {
                insets.left = 0;
                insets.top = 0;
                insets.right = tootlipIcon.getIconWidth();
                insets.bottom = 0;
            }
        } else {
            //Defensively adjust all the insets fields
            insets.left = 0;
            insets.top = 0;
            insets.right = 0;
            insets.bottom = 0;
        }
        return insets;
    }

    public boolean isBorderOpaque() {
        return false;
    }

    public void paintBorder(Component c, java.awt.Graphics g,
            int x, int y, int width, int height) {
        Graphics2D g2d = (Graphics2D) g;
        AbstractColoredCellRenderer ren = (AbstractColoredCellRenderer) c;
        if (ren.hasToolTipText()) {
            int iconY,iconX;

            //Determin unde se va desena iconul
            int halignment = ren.getHorizontalAlignment();
            if (halignment == SwingConstants.RIGHT) {
                iconX = 0;
                if (tootlipIcon.getIconHeight() < height) {
                    iconY = (height / 2) - (tootlipIcon.getIconHeight() / 2);
                } else {
                    iconY = 0;
                }
            } else {
                iconX = width - tootlipIcon.getIconWidth();
                if (tootlipIcon.getIconHeight() < height) {
                    iconY = (height / 2) - (tootlipIcon.getIconHeight() / 2);
                } else {
                    iconY = 0;
                }
            }

            g.setColor (Color.red);
            Composite composite = g2d.getComposite();
            AlphaComposite alpha;
            if (ren.isSelected())
                alpha = AlphaComposite.getInstance(AlphaComposite.SRC_OVER, 0.5F);
            else alpha = AlphaComposite.getInstance(AlphaComposite.SRC_OVER, 1F);
            try {
                g2d.setComposite(alpha);
                tootlipIcon.paintIcon(c, g, iconX, iconY);
            } finally {
                g2d.setComposite(composite);
            }
        }
    }
}
