/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package exenne.components.jtable.rowheader;

import javax.swing.AbstractListModel;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableModel;

/**
 * Un model de lista ce se conecteaza cu un table model.
 * Acest model poate fi vazut ca o extensie a table modelului
 * @author iulian
 */
public abstract class RowHeaderModel extends AbstractListModel implements TableModelListener {
    private TableModel tabelModel;

    /**
     * Constructorul principal
     * @param tabelModel 
     */
    public RowHeaderModel(TableModel tabelModel) {
        this.tabelModel = tabelModel;
        tabelModel.addTableModelListener(this);
    }

    /**
     * Obtin marimea de la tabel
     * @return 
     */
    @Override
    public int getSize() {
        return tabelModel.getRowCount();
    }

    /**
     * Obtin elementul din tabel
     * @param i
     * @return 
     */
    @Override
    public Object getElementAt(int i) {
        return getListCellData(tabelModel.getValueAt(i, 0));
    }

    /**
     * Metoda ce se suprascrie pentru a oferi componenta proprie spre desenare
     * @param tableObject
     * @return 
     */
    public abstract RowHeaderCellData getListCellData(Object tableObject);
    
    /**
     * Propag modificarile din tabel in lista
     * @param tme 
     */
    public void tableChanged(TableModelEvent tme) {
        int type = tme.getType();
        switch (type) {
            case TableModelEvent.INSERT:
                this.fireIntervalAdded(tme.getSource(), 
                        tme.getFirstRow(), tme.getLastRow());
                break;
            case TableModelEvent.DELETE:
                this.fireIntervalRemoved(tme.getSource(), 
                        tme.getFirstRow(), tme.getLastRow());
                break;
            case TableModelEvent.UPDATE:
                this.fireContentsChanged(tme.getSource(), 
                        tme.getFirstRow(), tme.getLastRow());
                break;
            default:
                break;                
        }
    }
}
