/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package exenne.components.sidebar;

import java.awt.*;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import javax.swing.*;

/**
 * Clasa aduce o mica modificare unui JPanel ce il face sa
 * fie sensibil la redimensionarile Sidebaruruilor din interior
 * Un sidebar poate fi folosit doar cu un JSensitivePanel
 * @author iulian
 */
public class JSensitivePanel extends JPanel {
    public static final int LEFT = 0;
    public static final int RIGHT = 1;
    public static final int TOP = 2;
    public static final int BOTTOM = 3;

    boolean isDragging;
    JResizeMarker marker;
    JSideBar leftside,rightside,topside,bottomside;

    //Marimea panelului
    public int lastWidth;
    public int lastHeight;

    /**
     * Constructorul doar initializeaza variabila Drag
     */
    public JSensitivePanel() {
        super();
        //Initializez membrii clasei
        leftside = null;
        rightside = null;
        topside = null;
        bottomside = null;
        isDragging = false;
        lastWidth = 0;
        lastHeight = 0;
        //Initilizez ascultatorul pentru resize
        addComponentListener(componentListener);
    }

    /**
     * Defineste sidebarurile pentru Sensitive Panel
     * @param sidebar
     * @param position
     */
    public void addSidebar(JSideBar sidebar, int position){
        switch (position) {
            case (LEFT):
                leftside = sidebar;
                super.add(sidebar,BorderLayout.WEST);
                break;
            case (RIGHT):
                rightside = sidebar;
                super.add(sidebar,BorderLayout.EAST);
                break;
            case (TOP):
                topside = sidebar;
                super.add(sidebar,BorderLayout.NORTH);
                break;
            case (BOTTOM):
                bottomside = sidebar;
                super.add(sidebar,BorderLayout.SOUTH);
                break;
            default:
                break;
        }
    }

    /**
     * Suprascriu ca sa adaug doar in Centru (ca sa protejez sidebarurile)
     * @param comp
     * @return
     */
    @Override
    public Component add(Component comp) {
       super.add(comp , BorderLayout.CENTER);
       return comp;
    }

    /**
     * Metoda este apecata de Copii clasei si il face pe acesta sa deseneze
     * markerul de resize deasupra copiilor
     * @param marker Obiectul asociat actiunii de drag
     */
    public void setDrag(JResizeMarker marker){
        isDragging = true;
        this.marker = marker;
    }

    /**
     * Se revine la starea normala comportament de JPanel
     */
    public void endDrag() {
        isDragging = false;
        repaint();
    }

    /**
     * Metoada suprascrisa permite desenarea unui JOutline deasupra tuturor Copiilor
     * @param g Conextul grafic
     */
    @Override
    protected void paintChildren(Graphics g) {
        super.paintChildren(g);

        if (isDragging)
            marker.paint(g);
    }

    ComponentListener componentListener = new ComponentListener() {

        public void componentResized(ComponentEvent e) {
            int curentWidth, curentHeight;
            curentWidth = getWidth();
            curentHeight = getHeight();
            if ( curentWidth < lastWidth ) {
                //Notify the sidePanels
                if (leftside != null) leftside.notifyResize();
                if (rightside != null) rightside.notifyResize();
            }
            if ( curentHeight < lastHeight ) {
                 if (topside != null) topside.notifyResize();
                if (bottomside != null) bottomside.notifyResize();               
            }
            lastWidth = curentWidth;
            lastHeight = curentHeight;
        }

        public void componentMoved(ComponentEvent e) {
        }

        public void componentShown(ComponentEvent e) {
        }

        public void componentHidden(ComponentEvent e) {
        }
    };
}
