/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package exenne.components.treetable.undosupport;

import exenne.components.treetable.Treetable;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;

/**
 *
 * @author iulian
 */
public class RemoveNodeFromParentStandardUndoableEdit extends AbstractUndoableEdit {
    //Definesc operatia
    private Treetable treetable;
    private DefaultMutableTreeNode deletedNode;

    //Pastrez informatii despre operatie
    private DefaultMutableTreeNode parentNode;
    private int position;
    private boolean isDeletedNodeExpanded;

    /**
     * Actiune pentru stergerea unui nod
     * @param node
     */
    public RemoveNodeFromParentStandardUndoableEdit(Treetable treetable,
            DefaultMutableTreeNode deletedNode) {
        //Configurez operatia
        this.treetable = treetable;
        this.deletedNode = deletedNode;
    }

    /**
     * Executa actiunea in sine
     */
    public void execute() {
        DefaultTreeModel model = (DefaultTreeModel) treetable
                .getTreetableModel().getTreeModel();
        this.parentNode = (DefaultMutableTreeNode) deletedNode.getParent();

        //PAstrez detalii despre starea nodului sters
        isDeletedNodeExpanded = treetable.isNodeExpanded(deletedNode);
        if (isDeletedNodeExpanded)
            treetable.collapseNode(deletedNode);

        //Ma asigur ca parintele este vizibil
        treetable.expandNode(parentNode);

        //Pastreza pozitia pe care se afla nodul
        this.position = model.getIndexOfChild(parentNode, deletedNode);

        //Fac actiunea de stergere
        model.removeNodeFromParent(deletedNode);
    }

    /**
     * Actiunea de anulare a stergerii
     * @throws CannotUndoException
     */
    @Override
    public void undo() throws CannotUndoException {
        super.undo();

        DefaultTreeModel model = (DefaultTreeModel) treetable
                .getTreetableModel().getTreeModel();
        model.insertNodeInto(deletedNode, parentNode, position);

        //Aduc parintele in fata
        treetable.expandNode(parentNode);

        //Refac starea nodului inserat
        if (isDeletedNodeExpanded)
            treetable.expandNode(deletedNode);
    }

    /**
     * Actiunea de refacere a
     * @throws CannotRedoException
     */
    @Override
    public void redo() throws CannotRedoException {
        super.redo();

        //Operatiunea de redo este aceiasi cu execute
        execute();
    }
}
