/*
 * Decompiled with CFR 0.152.
 */
package exenne.components.headerrenderer;

import exenne.components.headerrenderer.JHeaderSorterIcons;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.ListCellRenderer;
import javax.swing.RowSorter;
import javax.swing.UIManager;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;

public class MultilineHeaderRenderer
extends JPanel
implements TableCellRenderer {
    JList dataList = new JList();
    JLabel iconLabel;
    private static Color bgColor = Color.WHITE;
    private static Color fgColor = Color.BLACK;

    public MultilineHeaderRenderer() {
        this.dataList.setOpaque(true);
        this.dataList.setForeground(fgColor);
        this.dataList.setBackground(bgColor);
        ListCellRenderer renderer = this.dataList.getCellRenderer();
        ((JLabel)((Object)renderer)).setHorizontalAlignment(0);
        this.dataList.setCellRenderer(renderer);
        this.iconLabel = new JLabel();
        this.iconLabel.setOpaque(true);
        this.iconLabel.setForeground(fgColor);
        this.iconLabel.setBackground(bgColor);
        this.setOpaque(true);
        this.setForeground(fgColor);
        this.setBackground(bgColor);
        this.setLayout(new BorderLayout());
        this.setBorder(UIManager.getBorder("TableHeader.cellBorder"));
        this.add((Component)this.dataList, "Center");
        this.add((Component)this.iconLabel, "East");
    }

    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        RowSorter.SortKey key;
        RowSorter<? extends TableModel> sorter;
        List<RowSorter.SortKey> sortKeys;
        Iterator<RowSorter.SortKey> sortIterator;
        this.setFont(table.getFont());
        String str = value == null ? "" : value.toString();
        BufferedReader br = new BufferedReader(new StringReader(str));
        Vector<String> v = new Vector<String>();
        try {
            String line;
            while ((line = br.readLine()) != null) {
                v.addElement(line);
            }
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        this.dataList.setListData(v);
        boolean isSorted = false;
        if (table.getRowSorter() != null && (sortIterator = (sortKeys = (sorter = table.getRowSorter()).getSortKeys()).iterator()).hasNext() && (key = sortIterator.next()).getColumn() == column) {
            switch (key.getSortOrder()) {
                case ASCENDING: {
                    Icon icon = JHeaderSorterIcons.ASC.getIcon();
                    this.iconLabel.setIcon(icon);
                    isSorted = true;
                    break;
                }
                case DESCENDING: {
                    Icon icon = JHeaderSorterIcons.DESC.getIcon();
                    this.iconLabel.setIcon(icon);
                    isSorted = true;
                    break;
                }
            }
        }
        if (!isSorted) {
            this.iconLabel.setIcon(null);
        }
        return this;
    }
}

