/*
 * Decompiled with CFR 0.152.
 */
package exenne.components.popup;

import exenne.components.popup.JCopyPasteIcons;
import exenne.components.popup.JCopyPastePopup;
import exenne.components.transfer.TransferHandlerUtils;
import java.awt.event.ActionEvent;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.TransferHandler;

public class CopyPastePopupManager {
    public static final String NAME_CUT = "Cut";
    public static final String NAME_COPY = "Copy";
    public static final String NAME_PASTE = "Paste";
    public static final String ACTION_CUT = "Cut".toLowerCase();
    public static final String ACTION_COPY = "Copy".toLowerCase();
    public static final String ACTION_PASTE = "Paste".toLowerCase();
    private static JCopyPastePopup copyPastePopup = null;

    private CopyPastePopupManager() {
    }

    public static JCopyPastePopup getCopyPastePopup() {
        if (copyPastePopup == null) {
            copyPastePopup = new JCopyPastePopup();
        }
        return copyPastePopup;
    }

    public static Icon getCutIcon() {
        return JCopyPasteIcons.CUT.getIcon();
    }

    public static Icon getCopyIcon() {
        return JCopyPasteIcons.COPY.getIcon();
    }

    public static Icon getPasteIcon() {
        return JCopyPasteIcons.PASTE.getIcon();
    }

    public static boolean isCutEnabled(JComponent targetComponent) {
        return TransferHandlerUtils.isCutEnabled(targetComponent);
    }

    public static boolean isCopyEnabled(JComponent targetComponent) {
        return TransferHandlerUtils.isCopyEnabled(targetComponent);
    }

    public static boolean isPasteEnabled(JComponent targetComponent) {
        return TransferHandlerUtils.isPasteEnabled(targetComponent);
    }

    public static boolean recognizeCommand(String cmd) {
        return ACTION_COPY.equals(cmd) || ACTION_PASTE.equals(cmd) || ACTION_CUT.equals(cmd);
    }

    public static void handleEvent(ActionEvent e, JComponent targetComponent) {
        String cmd = e.getActionCommand();
        if (ACTION_CUT.equals(cmd)) {
            ActionEvent copyEvent = new ActionEvent(targetComponent, 1, "cut");
            TransferHandler.getCutAction().actionPerformed(copyEvent);
        } else if (ACTION_COPY.equals(cmd)) {
            ActionEvent copyEvent = new ActionEvent(targetComponent, 1, "copy");
            TransferHandler.getCopyAction().actionPerformed(copyEvent);
        } else if (ACTION_PASTE.equals(cmd)) {
            ActionEvent pasteEvent = new ActionEvent(targetComponent, 1, "paste");
            TransferHandler.getPasteAction().actionPerformed(pasteEvent);
        }
    }
}

