/*
 * Decompiled with CFR 0.152.
 */
package exenne.components.propertiespanel.editors;

import exenne.components.propertiespanel.IEditorChangeListener;
import exenne.components.propertiespanel.IPropertiesEditor;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.Collection;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class JSliderPropertiesEditor
extends JPanel
implements IPropertiesEditor,
ChangeListener {
    private Collection backingValues;
    private JSlider slider;
    private Vector<IEditorChangeListener> editorChangeListeners;

    public JSliderPropertiesEditor(Collection values) {
        this.backingValues = values;
        this.slider = new JSlider(0, 0, this.backingValues.size() - 1, 0);
        this.slider.setMajorTickSpacing(1);
        this.slider.setPaintTicks(true);
        Hashtable<Integer, JLabel> labelTable = new Hashtable<Integer, JLabel>();
        int counter = 0;
        for (Object backingValue : this.backingValues) {
            labelTable.put(counter, new JLabel(backingValue.toString()));
            ++counter;
        }
        this.slider.setLabelTable(labelTable);
        this.slider.setPaintLabels(true);
        this.slider.setSnapToTicks(true);
        this.initialize();
    }

    private void initialize() {
        this.setLayout(new BorderLayout());
        this.add((Component)this.slider, "Center");
        this.editorChangeListeners = new Vector();
        this.slider.addChangeListener(this);
    }

    public void setEnabled(boolean enabled) {
        this.slider.setEnabled(enabled);
    }

    public JComponent getContainerComponent() {
        return this;
    }

    public JComponent getEditorComponent() {
        return this.slider;
    }

    public void setEditorName(String name) {
        this.setName(name);
        this.slider.setName(name);
    }

    public void setValue(Class objectClass, Object renderedObject) {
        if (this.backingValues.contains(renderedObject)) {
            int counter = 0;
            int foundPosition = 0;
            for (Object object : this.backingValues) {
                if (object.equals(renderedObject)) {
                    foundPosition = counter;
                }
                ++counter;
            }
            this.slider.setValue(foundPosition);
        }
    }

    public Object getValue(Class objectClass) {
        int value = this.slider.getValue();
        return this.backingValues.toArray()[value];
    }

    public void stateChanged(ChangeEvent e) {
        for (IEditorChangeListener iEditorChangeListener : this.editorChangeListeners) {
            iEditorChangeListener.fireValueChanged();
        }
    }

    public void addEditorChangeListener(IEditorChangeListener listener) {
        this.editorChangeListeners.add(listener);
    }

    public void removeEditorChangeListener(IEditorChangeListener listener) {
        this.editorChangeListeners.remove(listener);
    }
}

