/*
 * Decompiled with CFR 0.152.
 */
package exenne.components.propertiespanel.undecided;

import exenne.components.utils.NumberUtils;
import java.math.BigDecimal;

public class UndecidedBigDecimal
implements Comparable {
    private BigDecimal bigDecimal;
    private boolean isUndecided;
    public static final String UNDECIDED_STRING = "<valori diferite>";

    public UndecidedBigDecimal(BigDecimal bigDecimal) {
        this.setValue(bigDecimal);
    }

    public UndecidedBigDecimal(String value) {
        this.setValue(value);
    }

    public BigDecimal getBigDecimal() {
        return this.bigDecimal;
    }

    public boolean isUndecided() {
        return this.isUndecided;
    }

    public boolean isDecided() {
        return !this.isUndecided;
    }

    public int compareTo(Object o) {
        if (o instanceof UndecidedBigDecimal) {
            UndecidedBigDecimal compareBigDecimal = (UndecidedBigDecimal)o;
            if (this.isDecided() && compareBigDecimal.isDecided() && this.bigDecimal != null) {
                return this.bigDecimal.compareTo(compareBigDecimal.getBigDecimal());
            }
            return -1;
        }
        throw new ClassCastException("Cannot compare");
    }

    public boolean equals(Object obj) {
        if (obj instanceof UndecidedBigDecimal) {
            UndecidedBigDecimal compareBigDecimal = (UndecidedBigDecimal)obj;
            if (this.isDecided()) {
                assert (this.bigDecimal != null) : "If is decided should not be null";
                if (compareBigDecimal.isDecided()) {
                    return this.bigDecimal.equals(compareBigDecimal.getBigDecimal());
                }
                return false;
            }
            return compareBigDecimal.isUndecided();
        }
        return false;
    }

    public int hashCode() {
        int hash = 5;
        hash = 29 * hash + (this.bigDecimal != null ? this.bigDecimal.hashCode() : 0);
        hash = 29 * hash + (this.isUndecided ? 1 : 0);
        return hash;
    }

    public void setValue(BigDecimal value) {
        if (value != null) {
            this.bigDecimal = value;
            this.isUndecided = false;
        } else {
            this.bigDecimal = null;
            this.isUndecided = true;
        }
    }

    public void setValue(String value) {
        BigDecimal localBigDecimalValue = NumberUtils.isValidNumber(value) ? NumberUtils.toBigDecimal(value) : null;
        this.setValue(localBigDecimalValue);
    }

    public String toString() {
        if (this.isUndecided()) {
            return UNDECIDED_STRING;
        }
        BigDecimal auxBigDecimal = this.bigDecimal.stripTrailingZeros();
        return auxBigDecimal.toPlainString();
    }
}

