/*
 * Decompiled with CFR 0.152.
 */
package exenne.components.undosystem.tutorial;

import exenne.components.undosystem.tutorial.BasicWindowMonitor;
import exenne.components.undosystem.tutorial.UndoableToggleEdit;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JRadioButton;
import javax.swing.JToggleButton;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.CompoundEdit;

public class UndoableToggleApp2
extends JFrame
implements ActionListener {
    private CompoundEdit edit;
    private JButton undoButton;
    private JButton redoButton;
    private JButton endButton;

    public UndoableToggleApp2() {
        JToggleButton tog = new JToggleButton("ToggleButton");
        JCheckBox cb = new JCheckBox("CompoundEdit ExampleCheckBox");
        JRadioButton radio = new JRadioButton("RadioButton");
        tog.addActionListener(this);
        cb.addActionListener(this);
        radio.addActionListener(this);
        Box buttonBox = new Box(1);
        buttonBox.add(tog);
        buttonBox.add(cb);
        buttonBox.add(radio);
        this.undoButton = new JButton("Undo");
        this.redoButton = new JButton("Redo");
        this.endButton = new JButton("End");
        this.undoButton.setEnabled(false);
        this.redoButton.setEnabled(false);
        this.endButton.setEnabled(false);
        this.undoButton.addActionListener(new ActionListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void actionPerformed(ActionEvent ev) {
                try {
                    UndoableToggleApp2.this.edit.undo();
                }
                catch (CannotUndoException ex) {
                    ex.printStackTrace();
                }
                finally {
                    UndoableToggleApp2.this.undoButton.setEnabled(UndoableToggleApp2.this.edit.canUndo());
                    UndoableToggleApp2.this.redoButton.setEnabled(UndoableToggleApp2.this.edit.canRedo());
                }
            }
        });
        this.redoButton.addActionListener(new ActionListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void actionPerformed(ActionEvent ev) {
                try {
                    UndoableToggleApp2.this.edit.redo();
                }
                catch (CannotRedoException ex) {
                    ex.printStackTrace();
                }
                finally {
                    UndoableToggleApp2.this.undoButton.setEnabled(UndoableToggleApp2.this.edit.canUndo());
                    UndoableToggleApp2.this.redoButton.setEnabled(UndoableToggleApp2.this.edit.canRedo());
                }
            }
        });
        this.endButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ev) {
                UndoableToggleApp2.this.edit.end();
                UndoableToggleApp2.this.endButton.setEnabled(false);
                UndoableToggleApp2.this.undoButton.setEnabled(UndoableToggleApp2.this.edit.canUndo());
                UndoableToggleApp2.this.redoButton.setEnabled(UndoableToggleApp2.this.edit.canRedo());
            }
        });
        Box undoRedoEndBox = new Box(0);
        undoRedoEndBox.add(Box.createGlue());
        undoRedoEndBox.add(this.undoButton);
        undoRedoEndBox.add(Box.createHorizontalStrut(2));
        undoRedoEndBox.add(this.redoButton);
        undoRedoEndBox.add(Box.createHorizontalStrut(2));
        undoRedoEndBox.add(this.endButton);
        undoRedoEndBox.add(Box.createGlue());
        Container content = this.getContentPane();
        content.setLayout(new BorderLayout());
        content.add((Component)buttonBox, "Center");
        content.add((Component)undoRedoEndBox, "South");
        this.setSize(400, 150);
    }

    public void actionPerformed(ActionEvent ev) {
        if (this.edit == null || !this.edit.isInProgress()) {
            this.edit = new CompoundEdit();
        }
        JToggleButton tb = (JToggleButton)ev.getSource();
        UndoableToggleEdit togEdit = new UndoableToggleEdit(tb);
        this.edit.addEdit(togEdit);
        this.endButton.setEnabled(true);
        this.undoButton.setEnabled(this.edit.canUndo());
        this.redoButton.setEnabled(this.edit.canRedo());
    }

    public static void main(String[] args) {
        UndoableToggleApp2 f = new UndoableToggleApp2();
        f.addWindowListener(new BasicWindowMonitor());
        f.setVisible(true);
    }
}

