/*
 * Decompiled with CFR 0.152.
 */
package exenne.components.undosystem.tutorial;

import exenne.components.undosystem.tutorial.BasicWindowMonitor;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Hashtable;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JRadioButton;
import javax.swing.JToggleButton;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.StateEdit;
import javax.swing.undo.StateEditable;

public class UndoableToggleApp4
extends JFrame
implements StateEditable,
ActionListener {
    private JToggleButton tog = new JToggleButton("ToggleButton");
    private JCheckBox cb = new JCheckBox("CheckBox");
    private JRadioButton radio = new JRadioButton("RadioButton");
    private JButton undoButton;
    private JButton redoButton;
    private JButton startButton;
    private JButton endButton;
    private StateEdit edit;

    public UndoableToggleApp4() {
        this.tog.addActionListener(this);
        this.cb.addActionListener(this);
        this.radio.addActionListener(this);
        Box buttonBox = new Box(1);
        buttonBox.add(this.tog);
        buttonBox.add(this.cb);
        buttonBox.add(this.radio);
        this.startButton = new JButton("Start");
        this.endButton = new JButton("End");
        this.undoButton = new JButton("Undo");
        this.redoButton = new JButton("Redo");
        this.startButton.setEnabled(true);
        this.endButton.setEnabled(false);
        this.undoButton.setEnabled(false);
        this.redoButton.setEnabled(false);
        this.startButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ev) {
                UndoableToggleApp4.this.edit = new StateEdit(UndoableToggleApp4.this);
                UndoableToggleApp4.this.startButton.setEnabled(false);
                UndoableToggleApp4.this.endButton.setEnabled(true);
                UndoableToggleApp4.this.undoButton.setEnabled(false);
                UndoableToggleApp4.this.redoButton.setEnabled(UndoableToggleApp4.this.edit.canRedo());
            }
        });
        this.endButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ev) {
                UndoableToggleApp4.this.edit.end();
                UndoableToggleApp4.this.startButton.setEnabled(true);
                UndoableToggleApp4.this.endButton.setEnabled(false);
                UndoableToggleApp4.this.undoButton.setEnabled(UndoableToggleApp4.this.edit.canUndo());
                UndoableToggleApp4.this.redoButton.setEnabled(UndoableToggleApp4.this.edit.canRedo());
            }
        });
        this.undoButton.addActionListener(new ActionListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void actionPerformed(ActionEvent ev) {
                try {
                    UndoableToggleApp4.this.edit.undo();
                }
                catch (CannotUndoException ex) {
                    ex.printStackTrace();
                }
                finally {
                    UndoableToggleApp4.this.undoButton.setEnabled(UndoableToggleApp4.this.edit.canUndo());
                    UndoableToggleApp4.this.redoButton.setEnabled(UndoableToggleApp4.this.edit.canRedo());
                }
            }
        });
        this.redoButton.addActionListener(new ActionListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void actionPerformed(ActionEvent ev) {
                try {
                    UndoableToggleApp4.this.edit.redo();
                }
                catch (CannotRedoException ex) {
                    ex.printStackTrace();
                }
                finally {
                    UndoableToggleApp4.this.undoButton.setEnabled(UndoableToggleApp4.this.edit.canUndo());
                    UndoableToggleApp4.this.redoButton.setEnabled(UndoableToggleApp4.this.edit.canRedo());
                }
            }
        });
        Box undoRedoBox = new Box(0);
        undoRedoBox.add(Box.createGlue());
        undoRedoBox.add(this.startButton);
        undoRedoBox.add(Box.createHorizontalStrut(2));
        undoRedoBox.add(this.endButton);
        undoRedoBox.add(Box.createHorizontalStrut(2));
        undoRedoBox.add(this.undoButton);
        undoRedoBox.add(Box.createHorizontalStrut(2));
        undoRedoBox.add(this.redoButton);
        undoRedoBox.add(Box.createGlue());
        Container content = this.getContentPane();
        content.setLayout(new BorderLayout());
        content.add((Component)buttonBox, "Center");
        content.add((Component)undoRedoBox, "South");
        this.setSize(400, 150);
    }

    public void actionPerformed(ActionEvent ev) {
        this.undoButton.setEnabled(false);
        this.redoButton.setEnabled(false);
    }

    public void storeState(Hashtable ht) {
        ht.put(this.tog, new Boolean(this.tog.isSelected()));
        ht.put(this.cb, new Boolean(this.cb.isSelected()));
        ht.put(this.radio, new Boolean(this.radio.isSelected()));
    }

    public void restoreState(Hashtable ht) {
        Boolean b3;
        Boolean b2;
        Boolean b1 = (Boolean)ht.get(this.tog);
        if (b1 != null) {
            this.tog.setSelected(b1);
        }
        if ((b2 = (Boolean)ht.get(this.cb)) != null) {
            this.cb.setSelected(b2);
        }
        if ((b3 = (Boolean)ht.get(this.radio)) != null) {
            this.radio.setSelected(b3);
        }
    }

    public static void main(String[] args) {
        UndoableToggleApp4 f = new UndoableToggleApp4();
        f.addWindowListener(new BasicWindowMonitor());
        f.setVisible(true);
    }
}

